/*
 * Saline_Level.c
 *
 *  Created on: Nov 7, 2015
 *      Author: ShitijAvlani
 */

#include <stdint.h>
#include <stdbool.h>
#include <analogRead.h>
#include <driverlib/sysctl.h>
#include <inc/tm4c123gh6pm.h>
#include <Saline_Level.h>


//PF0 switch; PA2 alarm

uint16_t sensorVal [4];
int count = 4, i, n, f;

void Saline_Level (void)
{

	Saline_Level_Read(sensorVal);

	for(i=0; i < count; i++)
	{
		if(sensorVal[i] < 2320)
		{
			Buzzer((4-i)*2);
			count = i;
		}
	}

}


void Sensor_Init (void)
{

	//Enable clock to Port A and Port F
	SYSCTL_RCGCGPIO_R |= ((1<<0) | (1<<5));
	//Set the direction of the GPIO port pins PA2, PF0
	GPIO_PORTA_DIR_R |= (1<<2);
	GPIO_PORTF_DIR_R &= ~(1<<0);
	//Set as GPIO Pins
	GPIO_PORTA_AFSEL_R &= ~(1<<2);
	GPIO_PORTF_AFSEL_R &= ~(1<<0);
	//Set the current drive strength
	GPIO_PORTA_DR8R_R |= (1<<2);
	GPIO_PORTF_DR2R_R |= (1<<0);
	//Enable Pull Up registers
	GPIO_PORTA_PUR_R |= (1<<2);
	GPIO_PORTF_PUR_R |= (1<<0);
	//Enable Digital Function
	GPIO_PORTA_DEN_R |= (1<<2);
	GPIO_PORTF_DEN_R |= (1<<0);
	//Reset PA Output
	GPIO_PORTA_DATA_R &= ~(1<<2);
	//Configure the interrupt to be falling edge triggered
	GPIO_PORTF_IM_R &= ~(1<<0);
	GPIO_PORTF_IS_R &= ~(1<<0);
	GPIO_PORTF_IBE_R &= ~(1<<0);
	GPIO_PORTF_IEV_R &= ~(1<<0);
	//Clear All Interrupts
	GPIO_PORTF_RIS_R = 0x00;
	//Enable the interrupt
	GPIO_PORTF_IM_R |= (1<<0);

}


void Buzzer (int reps)
{

	//TIMERA1 SETUP	(8/reps Hz)
	//Disable the timer
	TIMER1_CTL_R &= ~(1<<0);
	//Write the GPTMCFG witha a value of 0x00000000
	TIMER1_CFG_R = 0x00000000;
	//Configure as periodic
	TIMER1_TAMR_R |= (0X2<<0);
	//Count down timer
	TIMER1_TAMR_R &= ~(1<<4);
	//Load value to count down from
	TIMER1_TAILR_R = 0x001E8480 * reps;
	//Enable Interrupt when timer reaches 0
	TIMER1_IMR_R |= (1<<0);
	//Enable interrupt in NVIC
	NVIC_EN0_R |= (1<<(INT_TIMER1A-16));
	//Enable Timer
	TIMER1_CTL_R |= (1<<0);
	f = 0;
	n = reps/2;

}


void TIMER1A_Handler (void)
{

	TIMER1_ICR_R |= (1<<0);
	GPIO_PORTA_DATA_R ^= 0x04;
	f++;
	if(f == n)
		TIMER1_CTL_R &= ~(1<<0);

}


void PORTF_Handler (void)
{

	count = 4;
	GPIO_PORTF_ICR_R |= (1<<0);

}
