/*
 * TMP100.c
 *
 *  Created on: Sep 27, 2015
 *      Author: shitij
 */

#include <stdint.h>
#include <I2C_Comm.h>
#include <TMP100.h>

#define TMP100_Address		0x48

void Set_Resolution (uint8_t res)
{

	if(res > 0x03)
		return;

	unsigned char data [2];
	unsigned char *dataAdd;
	data [0] = 0x01;
	data [1] = (res << 5);
	dataAdd = &data[0];
	I2CWrite (TMP100_Address, dataAdd, 2);
	data [0] = 0x00;
	I2CWrite (TMP100_Address, dataAdd, 1);

}

float Get_Temp (void)
{

	unsigned char data [2];
	unsigned char *dataAdd;
	dataAdd = &data[0];
	data [0] = 0x00;
	I2CWrite (TMP100_Address, dataAdd, 1);
	I2CRead (TMP100_Address, dataAdd, 2);
	return ((((data[0] << 8 ) | (data[1])) >> 4) * 0.0625);

}
