/*
 * UART_Comm1.c
 *
 *  Created on: Oct 9, 2015
 *      Author: shitij
 */


#include <stdint.h>
#include <inc/tm4c123gh6pm.h>


void UART_Init (void)
{


	SYSCTL_RCGCUART_R |= (1<<1);  // activate UART1
	SYSCTL_RCGCGPIO_R |= (1<<2);  // activate port C

	UART1_CTL_R &= ~(0x00000001);    // disable UART
	UART1_IBRD_R = 8;     // IBRD = int(16,000,000/(16*115,200)) = int(8.68055)
	UART1_FBRD_R = 44;     // FBRD = round(0.68055 * 64 + 0.5) = 44
	UART1_LCRH_R = ((1<<6) | (1<<5) | (1<<4));  // 8 bit, no parity bits, one stop, FIFOs
	UART1_CTL_R |= (0x00000001);     // enable UART

	GPIO_PORTC_AFSEL_R |= ((1<<4) | (1<<5));    // enable alt funct on PC5-4
	GPIO_PORTC_DEN_R |= ((1<<4) | (1<<5));      // configure PC5-4 as UART1
	GPIO_PORTC_PCTL_R = ((GPIO_PORTC_PCTL_R & 0xFF00FFFF) + 0x00220000);
	GPIO_PORTC_AMSEL_R &= ~((1<<4) | (1<<5));   // disable analog on PC5-4


}


void printChar (unsigned char data)
{

	while((UART1_FR_R & (1<<5)) != 0);      // wait until TXFF is 0
	UART1_DR_R = data;

}

unsigned char readChar (void)
{

	return((unsigned char)(UART1_DR_R&0xFF));

}


void printString (unsigned char *string)
{

	while(*string)
		printChar(*(string++));

}


void printInt (uint16_t n)
{

	uint16_t new_value [5];
	int8_t x;
	uint8_t flag = 1;
	for (x = 0; ((x < 5)&&(flag == 1)); x++)
	{
		new_value[x] = n % 10;
		n /= 10;
		if(n == 0)
			flag = 0;
	}
	for ( x -= 1 ; x >= 0; x--)
		printChar (new_value[x] + 48);

}


uint16_t readInt(void)
{

	uint16_t n=0;            // this will be the return value
	unsigned char character;      // this is the input ASCII typed
	while(1)
	{
		while(((UART1_FR_R & (1<<4)) != 0));
		character = readChar(); // accepts input
		if((character < '0') || (character > '9'))
			return n;                // quit if not a number
		n = 10*n+(character-0x30);
	}

}



void printFloat (float f)
{

	float temp = f;
	int n = (int)(temp);
	temp -= n;
	if( n < 0)
	{
		printChar ('-');
		n *= -1;
	}

	printInt (n);
	printChar ('.');
	if(temp > 0)
	{
		for( ; temp > 0; )
		{
			n = (int)(temp * 10);
			printInt (n);
			temp = (temp * 10) - n;
		}
	}
	else
		printInt(0);

}
