/*
 * analogRead.c
 *
 *  Created on: Sep 26, 2015
 *      Author: shitij
 */


#include <stdint.h>
#include <inc/tm4c123gh6pm.h>
#include <analogRead.h>

uint16_t adcWeight;

void ADC_Initialize (void)
{

	//ADC CONFIGURE

	//Activate ADC Clock
	SYSCTL_RCGCADC_R |= ((1<<0) | (1<<1));
	//Enable clock to GPIO port B, D, E
	SYSCTL_RCGCGPIO_R |= ((1<<1) | (1<<3) | (1<<4));

	//Set direction of PE0, PE1, PE2, PE3 as input
	GPIO_PORTE_DIR_R &= ~((1<<0) | (1<<1) | (1<<2) | (1<<3));
	//Select Alternate function on PE0, PE1, PE2, PE3
	GPIO_PORTE_AFSEL_R |= ((1<<0) | (1<<1) | (1<<2) | (1<<3));
	//Clear Digital Enable on PE0, PE1, PE2, PE3
	GPIO_PORTE_DEN_R &= ~((1<<0) | (1<<1) | (1<<2) | (1<<3));
	//Disable Analog Isolation Circuit
	GPIO_PORTE_AMSEL_R |= ((1<<0) | (1<<1) | (1<<2) | (1<<3));

	//Set direction of PD0, PD1, PD2, PD3 as input
	GPIO_PORTD_DIR_R &= ~((1<<0) | (1<<1) | (1<<2) | (1<<3));
	//Select Alternate function on PD0, PD1, PD2, PD3
	GPIO_PORTD_AFSEL_R |= ((1<<0) | (1<<1) | (1<<2) | (1<<3));
	//Clear Digital Enable on PD0, PD1, PD2, PD3
	GPIO_PORTD_DEN_R &= ~((1<<0) | (1<<1) | (1<<2) | (1<<3));
	//Disable Analog Isolation Circuit
	GPIO_PORTD_AMSEL_R |= ((1<<0) | (1<<1) | (1<<2) | (1<<3));

	//Set direction of PB4, PB5 as input
	GPIO_PORTB_DIR_R &= ~((1<<4) | (1<<5));
	//Select Alternate function on PB4, PB5
	GPIO_PORTB_AFSEL_R |= ((1<<4) | (1<<5));
	//Clear Digital Enable on PB4, PB5
	GPIO_PORTB_DEN_R &= ~((1<<4) | (1<<5));
	//Disable Analog Isolation Circuit
	GPIO_PORTB_AMSEL_R |= ((1<<4) | (1<<5));

	//SAMPLE SEQUENCER CONFIGURE

	//FOR ADC1 (Sample Sequencer 1)

	//Disable sample sequencer 1
	ADC1_ACTSS_R &= ~(1<<1);
	//Countinuously sample
	ADC1_EMUX_R = (0x5<<4);//0Xf
	//Select my analog input. PE1 -> AIN2, PE0 -> AIN3, PB4 -> AIN10, PB5 -> AIN11
	ADC1_SSMUX1_R = ((0x2<<0) | (0x3<<4) | (0x0A<<8) | (0x0B<<0));
	//Third sample is end of sequence
	ADC1_SSCTL1_R |= (1<<13);
	//Enable Sample Sequencer 1
	ADC1_ACTSS_R |= (1<<1);


	//FOR ADC0 (Sample Sequencer 1)

	//Disable sample sequencer 1
	ADC0_ACTSS_R &= ~(1<<1);
	//Countinuously sample
	ADC0_EMUX_R = (0xF<<4);
	//Select my analog input. PE3 -> AIN0, PE2 -> AIN1
	ADC0_SSMUX1_R = ((0x0<<0) | (0x1<<4));
	//Second sample is end of sequence
	ADC0_SSCTL1_R |= (1<<5);
	//Enable Sample Sequencer 1
	ADC0_ACTSS_R |= (1<<1);

	//FOR ADC0 (Sample Sequencer 2)

	//Disable sample sequencer 2
	ADC0_ACTSS_R &= ~(1<<2);
	//Countinuously sample
	ADC0_EMUX_R = (0xF<<8);
	//Select my analog input. PD3 -> AIN4, PD2 -> AIN5, PD1 -> AIN6, PD0 -> AIN7
	ADC0_SSMUX2_R = ((0x4<<0) | (0x5<<4) |(0x6<<8) | (0x7<<12));
	//Fourth sample is end of sequence
	ADC0_SSCTL2_R |= (1<<13);
	//Enable Sample Sequencer 2
	ADC0_ACTSS_R |= (1<<2);


}

void SPO2_Read ( uint16_t *s0, uint16_t *s1 )
{

	*s0 = (ADC0_SSFIFO1_R & 0x0000FFFF);
	*s1 = (ADC0_SSFIFO1_R & 0x0000FFFF);

}

void PPG_ECG_Resp_Read ( uint16_t *s0 )
{

	uint8_t i;
	for(i = 0; i < 3; i++)
		*(s0++) = (ADC1_SSFIFO1_R & 0x0000FFFF);
	adcWeight = (ADC1_SSFIFO1_R & 0x0000FFFF);

}

void Saline_Level_Read (uint16_t *s0)
{

	int i;
	for(i = 0; i < 4; i++)
		s0[i] = (ADC0_SSFIFO2_R & 0x0000FFFF);

}

float Weight_Read (void)
{

	float a = adcWeight*40.0;
	float b = a/4095.0;
	return b;

}
