/*
 * interrupt_Setup.c
 *
 *  Created on: Sep 26, 2015
 *      Author: shitij
 */


#include <stdint.h>
#include <inc/tm4c123gh6pm.h>
#include <interrupt_Setup.h>
#include <analogRead.h>
#include <UART_Comm.h>
#include <Saline_Level.h>
#include <Blood_Pressure.h>
#include <SPO2.h>
#include <TMP100.h>


uint16_t signal [3];
float temp, spo2;
unsigned char bpReading [15];


void interrupt_Setup (void)
{

	//Send clock to required GPTM
	SYSCTL_RCGCTIMER_R |= (1<<0)|(1<<1)|(1<<2);


	//TIMERA0 SETUP	(500Hz)
	//Disable the timer
	TIMER0_CTL_R &= ~(1<<0);
	//Write the GPTMCFG witha a value of 0x00000000
	TIMER0_CFG_R = 0x00000000;
	//Configure as periodic
	TIMER0_TAMR_R |= (0X2<<0);
	//Count down timer
	TIMER0_TAMR_R &= ~(1<<4);
	//Load value to count down from
	TIMER0_TAILR_R = 0x00007D00;
	//Enable Interrupt when timer reaches 0
	TIMER0_IMR_R |= (1<<0);
	//Enable interrupt in NVIC
	NVIC_EN0_R |= (1<<(INT_TIMER0A-16));
	//Enable Timer
	TIMER0_CTL_R |= (1<<0) | (1<<5);


	//TIMERA2 SETUP	(0.1Hz)
	//Disable Timer
	TIMER2_CTL_R &= ~(1<<0);
	//Write the GPTMCFG witha a value of 0x00000000
	TIMER2_CFG_R = 0x00000000;
	//Configure as periodic
	TIMER2_TAMR_R |= (0X2<<0);
	//Count down timer
	TIMER2_TAMR_R &= ~(1<<4);
	//Load value to count down from
	TIMER2_TAILR_R = 0x09896800;
	//Enable Interrupt when timer reaches 0
	TIMER2_IMR_R |= (1<<0);
	//Enable interrupt in NVIC
	NVIC_EN0_R |= (1<<(INT_TIMER2A-16));
	//Enable Timer
	TIMER2_CTL_R |= (1<<0);

}


void TIMER0A_Handler (void)
{

	PPG_ECG_Resp_Read(signal);

	printChar ('(');
	printInt (signal[0]);
	printChar (',');
	printInt (signal[1]);
	printChar (',');
	printInt (signal[2]);
	printChar (')');
	printChar('\n');

	TIMER0_ICR_R |= (1<<0);

}


void TIMER2A_Handler (void)
{

	TIMER2_ICR_R |= (1<<0);
	/*
	TIMER0_CTL_R &= ~(1<<0);
	TIMER2_CTL_R &= ~(1<<0);
	printChar('#');
	printFloat(Get_Temp());
	printChar(',');
	printFloat(SPO2());
	printChar(',');
	printFloat(Weight_Read());
	printString("#\n");
	Read_BP(bpReading);
	printChar('@');
	uint8_t i;
	for(i = 1; i < 14; i++)
		printChar (bpReading[i]);
	printString ("@\n");
	//Saline_Level();
	*/
}
