/************************************************************************************************************
 * 											Board_Initialization.c
 ***********************************************************************************************************/
 /* Created on: 07 luglio 2017
 *  Author: Maria Angela Cianci
 */
#include <msp430.h>
#include <Board_Initialization.h>
#include <Tlv_structure.h>
#include <Definizioni_Display.h>

void configurazione_iniziale() {
	__bis_SR_register (OSCOFF);

	/*Configurazione GPIO*/
			P1DIR|=0xFF;		//Tutti i pin della porta 1 sono output
	/*Set BIT3, BIT4, BIT5, BIT6 E BIT7 della porta 1 come output--> PIN che mi attivano i 4 display (+LEDs)*/
			P1DIR|=0xF8;
			P1SEL=0x00;
	/* Set BIT5 e BIT6 e BIT7 della porta 2 come output, gli altri bit come input*/
			//P2DIR|=(B_OSC+LATCH_ENABLE);
			P2DIR|=0xE0;
			P2SEL=0x00;


			P3DIR|=0xFF;


			P4DIR|=0xFF;		//Tutti i pin della porta 4 sono output
			P4SEL=0x00;


	/*Configurazione Clock Module*/
		BCSCTL2= SELM_0+DIVM_0+DIVS_3;
		BCSCTL1= CALBC1_16MHZ;
		DCOCTL= CALDCO_16MHZ;

	/*Verifica dei dati di calibrazione*/
		if (verifica_tlv() != 0)  {

	/*Si procede alla configurazione manuale del Clock Module*/
			BCSCTL1|= BIT0+BIT1+BIT2+BIT3;
			BCSCTL1|= DIVA_3;
			DCOCTL&= ~(BIT5+BIT6);
			DCOCTL|= BIT7;
			BCSCTL2=SELM_0+DIVM_0+DIVS_3;

		}

	/*Configurazione Timer Module: TIMER A*/
		TACCR0=offset_timerA;
		TACTL=TASSEL_2+ID_0+MC_2+TACLR;
		TACCTL0=CCIS_0+CCIE;

	/*Configurazione Timer Module: TIMER B*/
		TBCCR0=offset_timerB;
		TBCTL=TBSSEL_2+ID_1+MC_2+CNTL_0+TBCLR;
		TBCCTL0=CCIS_1+CCIE;

	/*Attivazione Global Interrupt*/
		__enable_interrupt();
}


