/************************************************************************************************************
 * 											Definizioni_Display.h
 ***********************************************************************************************************/
 /* Created on: 03 luglio 2017
 *  Author: Maria Angela Cianci
 */

#ifndef DEFINIZIONI_H_
#define DEFINIZIONI_H_
/************************************************************************************************************
 * 								DEFINIZIONI DELLE MASCHERE DEI CARATTERI
 * Indica quali LED di ogni display 7 segmenti accendere/spegnere per visualizzare il numero.
 * SEG_ON 0, SEG_OFF 1.
 *
 ***********************************************************************************************************/
#define mask_00 	(0b11000000)
#define mask_01		(0b11111001)
#define	mask_02		(0b10100100)
#define	mask_03		(0b10110000)
#define	mask_04		(0b10011001)
#define	mask_05		(0b10010010)
#define	mask_06		(0b10000010)
#define	mask_07		(0b11111000)
#define	mask_08		(0b10000000)
#define mask_09		(0b10010000)
#define	mask_DP		(0b01111111)

/************************************************************************************************************
 * 											DELAY DEL DISPLAY
 * Imposto un ritardo SW necessario per la visualizzazione sul display.
 *
 ***********************************************************************************************************/
#define DELAY	65000

/************************************************************************************************************
 * 										DEFINIZIONI DELL'HARDWARE: DISPLAY
 * Definizioni delle linee di pilotaggio dei display.
 *
 ***********************************************************************************************************/
#define COL0	BIT3
#define COL1	BIT4
#define COL2	BIT5
#define COL3	BIT6
/***********Definizione del bit su cui controllo il timing con l'oscilloscopio in fase di DEBUG*************/
#define B_OSC 	BIT5

/************************************************************************************************************
 * 										DEFINIZIONI DELL'HARDWARE: LATCH D
 * Definisco il pin di latch enable. E' essenziale per la visualizzazione dei valori
 * sul singolo display selezionato.
 ***********************************************************************************************************/
#define LATCH_ENABLE	BIT6

/************************************************************************************************************
 * 											GESTIONE DEI 4 DISPLAY
 * Utilizzo un array di tipo "char" senza segno per la sequenza dei 4 display.
 * Creo anche una variabile "puntatore" che verr utilizzata per la scansione dei display,indicando
 * quale display  acceso.
 *
 ***********************************************************************************************************/
unsigned char display [5];
char display_ptr;
 /************************************************************************************************************
  *										PROTOTIPI DELLE FUNZIONI per il DISPLAY
  ***********************************************************************************************************/
 void display_initialization ();
 void display_startup (unsigned int numero);
 void delay_display (unsigned long d);

#endif /* DEFINIZIONI_H_ */
