/************************************************************************************************************
 * 											Display.c
 ***********************************************************************************************************/
 /* Created on: 22 giugno 2017
 *  Author: Maria Angela Cianci
 */
/************************************************************************************************************
 * 									INIZIALIZZAZIONE DEL DISPLAY
  ***********************************************************************************************************/
#include <msp430.h>
#include <Definizioni_Display.h>
#include <Timer_Variable.h>
#include <Board_Initialization.h>
#include <Definizioni_Tastiera.h>
#include <Watchdog.h>
/************************************************************************************************************
 * 										ARRAY PER LA DECODIFICA
 * Definisco un array di tipo "char" per la decodifica dei numeri (per cui ho creato le maschere).
 *
 ***********************************************************************************************************/
const char MASK_DECODE []= {mask_00,mask_01,mask_02,mask_03,mask_04,mask_05,mask_06,mask_07,mask_08,mask_09,mask_DP};

void delay_display (unsigned long d) {
  unsigned long i;
  for (i=0;i<d;i++);

}

void display_startup (unsigned int numero) {

	int short i=0;
	/*Ciclo per dividere cifra per cifra il numero nel corrispondente display*/
	for (i=0;i<4;i++) {
		display[i]= numero%10;
		numero= numero/10;
		}
}


#pragma vector= TIMERA0_VECTOR
__interrupt void timerDISPLAY (void) {
	TACCR0+= offset_timerA; //Aggiungo l'offset a TACCR0

//	P2OUT^=B_OSC; 			//Toggle x prova DEBUG OSCILLOSCOPIO

	/*Spegne tutti i display*/
	P1OUT|= (COL0+COL1+COL2+COL3);
	display_ptr= (display_ptr%4);
	P4OUT= MASK_DECODE [display[display_ptr]];
	P2OUT|=LATCH_ENABLE; 	//LATCH_ENABLE=1;
	P2OUT&=~LATCH_ENABLE;	//LATCH_ENABLE=0;

	switch (display_ptr) {
	/*Attiva il display indicato dal puntatore, mettendo a ZERO il pin corrispondente*/
	case 0: P1OUT&= ~COL3; break;
	case 1:	P1OUT&= ~COL2; break;
	case 2:	P1OUT&= ~COL1; break;
	case 3:	P1OUT&= ~COL0; break;
	}
	display_ptr ++;

	if (time_counter<4) {
		time_counter++;
	}
	else {
		time_counter=0;
		timer_10ms++;
		 __no_operation();
		 __no_operation();
		 tastiera_standard();
		 __no_operation();
		 __no_operation();
		 __no_operation();
		 __no_operation();
		 __no_operation();

		//P2OUT^=B_OSC;

		if (timer_10ms>9) {
			timer_10ms=0;
			timer_100ms++;
		}

		if (timer_100ms>9) {
			timer_100ms=0;
			timer_1s++;
			//P2OUT^=B_OSC;
		}

		if (timer_1s>59) {
			timer_1s=0;
			timer_1min++;

		}
		if (timer_1min>59) {
			timer_1min=0;
			timer_1h++;

		}
	}
}

void display_initialization () {
	/*Attivo l'interrupt per il timer*/
	TACCTL0=CCIS_0+CCIE;
	//__enable_interrupt();

	/*Spengo tutti i display e inizializzo il contatore che mi scandir i display*/
	P1OUT|=(COL0+COL1+COL2+COL3);
	display_ptr=0;
}
