;	/***********************************************************************************************************
;	* 											Tastiera.asm
;	***********************************************************************************************************/
;	/* Created on: 24 luglio 2017
;	*  Author: Maria Angela Cianci
;	*/

;***************************************************************************************************************
;	La macro tastiera gestisce la pressione dei tasti e la funzione del tasto premuto, purch il dat gli arrivi
; 	all'interno del registro R4 in posizione LSB. Questa sar poi la funzione che vado a chiamare per il
;	controllo della tastiera (tasto premuto o no, per quanto tempo, ecc...).
;***************************************************************************************************************
;***************************************************************************************************************
;	La direttiva cdecl mi permettere di includere i vari header file di cui ho bisogno per il funzionamento
;	del programma.
;***************************************************************************************************************

		.cdecls C,LIST, "msp430g2744.h"
		.cdecls C,LIST, "Definizioni_Tastiera.h"
		.text
		.align 2
		.bss	TASTO,1
		.bss	OLD_TASTO,1
		.bss	PRENDITASTO,1
		.bss	FLAG_VARI,2,2
		.bss	TIMER_BLINK,1
		.bss	TIMER_TASTOSOLO,1
		.global	TASTO
		.global	tastiera_standard

tastiera_standard:	.asmfunc
				push.w	R4
				push.w	R5
				push.w	R6
				push.w	R7
				push.w	R8
				push.w	R9
				push.w	R10
				push.w	R11
				push.w	SP
				mov.b	P2IN, R4
				inv.b	R4
				and.b	#00111111, R4
				cmp.b 	OLD_TASTO, R4
				jeq		tasto_premuto
ritasto:			mov.b 	R4, OLD_TASTO
				clr.b	TASTO
				bic.w	#(FLAG_TASTOCONTINUO+FLAG_TASTOSOLO+FLAG_TASTOPREMUTO),FLAG_VARI
				mov.b	#CAMPIONI_TASTI, PRENDITASTO
				clr.b	TIMER_TASTOSOLO
				br		#tastiera_exit
tasto_premuto:	bit.w	#(FLAG_TASTOCONTINUO+FLAG_TASTOSOLO+FLAG_TASTOPREMUTO),FLAG_VARI
				jne		PRESO
				dec.b	PRENDITASTO
				jn		PRESO
				mov.b	R4, OLD_TASTO
				br		#tastiera_exit
PRESO:			mov.b	#CAMPIONI_TASTI, PRENDITASTO
				mov.b	OLD_TASTO, TASTO
				tst.b	TASTO
				jeq		ritasto
				bit.b	#TIMER_BLINK800,TIMER_TASTOSOLO
				jne		tasto_continuo
				bit.w	#(FLAG_TASTOCONTINUO + FLAG_TASTOSOLO),FLAG_VARI
				jne		tastiera_exit
				bis.w	#FLAG_TASTOSOLO, FLAG_VARI
				bic.b	#FLAG_TASTOCONTINUO, FLAG_VARI
				br		#tastiera_exit
tasto_continuo:	bis.b	#TIMER_BLINK800, TIMER_TASTOSOLO
				bis.w	#FLAG_TASTOCONTINUO, FLAG_VARI
				bic.w	#FLAG_TASTOSOLO, FLAG_VARI
tastiera_exit:
				pop.w	SP
				pop.w	R11
				pop.w	R10
				pop.w	R9
				pop.w	R8
				pop.w	R7
				pop.w	R6
				pop.w	R5
				pop.w	R4
				.endasmfunc

