/************************************************************************************************************
 * 											Tlv_Structure.c
 ***********************************************************************************************************/
 /* Created on: 13 luglio 2017
 *  Author: Maria Angela Cianci
 */

/************************************************************************************************************
 * 											VERIFICA DEI TLV DATA
 * Verifica i dati della calibrazione presenti nel segmento A della Flash
 * La funzione ritorna 0 se i dati sono validi, -1 altrimenti.
 *
***********************************************************************************************************/
#include <msp430.h>
#include <Board_Initialization.h>
#include <Tlv_Structure.h>

#define TLV_CHECKSUM 0x10C0

/*Questa funzione permette di calcolare il checksum*/
static unsigned int calcola_checksum (unsigned int *indirizzo, unsigned int lunghezza);

/*La funzione di verifica somma il valore predefinito di TLV_CHECKSUM con il valore dato
 * dalla funzione di calcolo*/

int verifica_tlv() {

	return (TLV_CHECKSUM + calcola_checksum((unsigned int *) 0x10C2, 62));

}

static unsigned int calcola_checksum (unsigned int *data, unsigned int lunghezza) {
	unsigned int c=0;
	lunghezza= lunghezza/2;
	while ((lunghezza--)>0)
		c^= *(data++);
	return c;
}
