/************************************************************************************************************
 * 											Watchdog.c
 ***********************************************************************************************************/
 /* Created on: 14 luglio 2017
 *  Author: Maria Angela Cianci
 */

#include <msp430.h>
#include <Watchdog.h>
#include <Timer_Variable.h>
#include <Board_Initialization.h>
#include <Definizioni_Display.h>

void delay_watchdog (unsigned long c) {
  unsigned long i;
  for (i=0;i<c;i++);
}

void watchdog_disable (void) {
	//Disattivo il watchdog timer
	WDTCTL = WDTPW | WDTHOLD;
}

#pragma vector= TIMERB0_VECTOR
__interrupt void timerWATCHDOG (void) {
	TBCCR0+= offset_timerB;	//Aggiungo l'offset a TBCCR0
	timeWDT_counter++;
}

void watchdog (void) {
	/*Reset periodico (ogni 4ms) del watchdog*/

	if(timeWDT_counter> 1) {
		WDTCTL= WDTPW | WDTCNTCL;
		timeWDT_counter=0;
		P2OUT^=B_OSC;
}
}

void watchdog_enable (void) {
    /*Attiva il watchdog con:
     * -SMCLK come sorgente a 2MHz;*/

    WDTCTL = WDTPW| WDTCNTCL|WDTIS0;
    TBCCTL0=CCIS_1+CCIE;
   //__enable_interrupt();
}


