@echo off
REM *************************************************************************
REM This script is used to run JavaScript-based DSS scripts.
REM
REM If eclipsec.exe is present, it will use the headless script launcher
REM to run the script
REM
REM Otherwise, it does this by setting up the necessary environment and invoking the
REM Rhino Javascript engine.
REM
REM Usage: dss DSS_JAVASCRIPT_FILE (to use the Rhino Shell)
REM		   dss -dss.debug DSS_JAVASCRIPT_FILE (to use the Rhino Debugger, if eclipsec.exe is present)
REM
REM *************************************************************************

setlocal ENABLEDELAYEDEXPANSION

set DEBUGSERVER=%~dp0..\..\DebugServer

if not exist "!DEBUGSERVER!\..\..\eclipse\eclipsec.exe" (
	REM if eclipsec.exe is not present, use the old way of launching the script 
	goto LAUNCH_DSS_SCRIPT
)

REM determine if we are using Rhino debugger
set NeedDebug=0
if %1 == -dss.debug set NeedDebug=1

REM loop code for determine the string of arguments after the first one (used for removing the -dss.debug if present
SHIFT
set ArgsAfterFirst=%1

:ArgLoop
	if "%2" == "" goto EndArgLoop
	set ArgsAfterFirst=%ArgsAfterFirst% %2
	SHIFT
	goto ArgLoop
:EndArgLoop

REM use the new headless script launcher
:LAUNCH_IDE_SCRIPT
if %NeedDebug% == 1 (
	!DEBUGSERVER!\..\..\eclipse\eclipsec.exe -nosplash -application com.ti.ccstudio.apps.runScript -dss.debug -dss.rhinoArgs "%ArgsAfterFirst%"
) else (
	!DEBUGSERVER!\..\..\eclipse\eclipsec.exe -nosplash -application com.ti.ccstudio.apps.runScript -dss.rhinoArgs "%*"
)

goto THEEND

:LAUNCH_DSS_SCRIPT

REM Path to Rhino JAR File
set RHINO_JAR="!DEBUGSERVER!\packages\ti\dss\java\js.jar"

REM Path to DVT Scripting JAR File
set DVT_SCRIPTING_JAR="!DEBUGSERVER!\..\dvt\scripting\dvt_scripting.jar"

REM Path to DebugServer JAR File
set SCRIPTING_JARS="!DEBUGSERVER!\packages\ti\dss\java\dss.jar"

REM If this is CCS (rather than stand-alone DSS) also add Eclipse's Equinox Launcher JAR to to the classpath
REM (need to modify to match the version of the JAR of the current version in Eclipse
if exist "!DEBUGSERVER!\..\..\eclipse\plugins\org.eclipse.equinox.launcher_1.2.0.v20110502.jar" (
	set SCRIPTING_JARS=!SCRIPTING_JARS!;"!DEBUGSERVER!\..\..\eclipse\plugins\org.eclipse.equinox.launcher_1.2.0.v20110502.jar"
)

REM Name of Rhino Shell Java Application
set RHINO_SHELL=org.mozilla.javascript.tools.shell.Main

REM Name of Rhino Debugger Java Application
set RHINO_DEBUGGER=org.mozilla.javascript.tools.debugger.Main

REM add path to Windows 32-bit on Windows 64-bit (WOW64) folder for 64bit Windows to use the 32bit applications.
!DEBUGSERVER!\..\common\bin\fs --version > NUL
if %ERRORLEVEL% EQU 64 goto SETUP_JRE_PATH
if exist "!SYSTEMROOT!\SysWOW64\" set PATH=!SYSTEMROOT!\SysWOW64\;!PATH!
 
:SETUP_JRE_PATH
REM If the user chose to install the JRE with this DSS install - use that JRE. 
if exist "!DEBUGSERVER!\..\jre" (
	set JAVA_HOME=!DEBUGSERVER!\..\jre
	set PATH=!DEBUGSERVER!\..\jre\bin;!PATH!
	goto LAUNCH_SCRIPT
)

REM If this CCS (rather than stand-alone DSS) the installed jre is in \eclipse\jre
if exist "!DEBUGSERVER!\..\..\eclipse\jre" (
	set JAVA_HOME=!DEBUGSERVER!\..\..\eclipse\jre
	set PATH=!DEBUGSERVER!\..\..\eclipse\jre\bin;!PATH!
	goto LAUNCH_SCRIPT
)

REM Launch Rhino script engine.  Import the scripting package.
:LAUNCH_SCRIPT
REM Set parameters to be passed to the script.
REM Need to do it this way to use SHIFT to overcome limitation to handle
REM parameters up to only %9.
REM Support up to max of 20 parameters. Increase as needed.
SET PARAM01=%1
SET PARAM02=%2
SET PARAM03=%3
SET PARAM04=%4
SET PARAM05=%5
SET PARAM06=%6
SET PARAM07=%7
SET PARAM08=%8
SET PARAM09=%9
SHIFT
SET PARAM10=%9
SHIFT
SET PARAM11=%9
SHIFT
SET PARAM12=%9
SHIFT
SET PARAM13=%9
SHIFT
SET PARAM14=%9
SHIFT
SET PARAM15=%9
SHIFT
SET PARAM16=%9
SHIFT
SET PARAM17=%9
SHIFT
SET PARAM18=%9
SHIFT
SET PARAM19=%9
SHIFT
SET PARAM20=%9


java.exe -Xms40m -Xmx384m -cp !RHINO_JAR!;!SCRIPTING_JARS!;!DVT_SCRIPTING_JAR! !RHINO_DEBUGGER! %PARAM01% %PARAM02% %PARAM03% %PARAM04% %PARAM05% %PARAM06% %PARAM07% %PARAM08% %PARAM09% %PARAM10% %PARAM11% %PARAM12% %PARAM13% %PARAM14% %PARAM15% %PARAM16% %PARAM17% %PARAM18% %PARAM19% %PARAM20%

:THEEND
endlocal
