#!/bin/bash
# ******************************************************************************
# * FILE PURPOSE: Compiler test situation
# ******************************************************************************

set -x #echo on

CGT_PRU_DIR=/opt/ti10/ti-cgt-pru_2.1.4
CGT_C66x_DIR=/opt/ti10/ccsv7/tools/compiler/ti-cgt-c6000_8.1.2

mkdir -p obj_firmware/am571x/clpru_0
mkdir -p obj_firmware/am571x/clpru_1
mkdir -p bin_firmware/am571x


# ******************************************************************************
# * FILE PURPOSE: Compilation of clpru based firmware
# ******************************************************************************

${CGT_PRU_DIR}/bin/clpru -DMAKEFILE_BUILD -v3 -g --endian=little --diag_wrap=off --diag_warning=225 --display_error_number --hardware_mac=on --preproc_with_compile -eo.opru   -DPRU0 -Dpru0    -DSOC_AM571x -I/opt/ti10/ccsv6/ccs_base/pru/include -I${CGT_PRU_DIR}/include -Isrc/ -fr=obj_firmware/am571x/clpru_0 -fs=obj_firmware/am571x/clpru_0 --preproc_dependency="micro_scheduler.d" src/micro_scheduler.asm

${CGT_PRU_DIR}/bin/clpru -DMAKEFILE_BUILD -v3 -g --endian=little --diag_wrap=off --diag_warning=225 --display_error_number --hardware_mac=on --preproc_with_compile -eo.opru   -DPRU0 -Dpru0    -DSOC_AM571x -I/opt/ti10/ccsv6/ccs_base/pru/include -I${CGT_PRU_DIR}/include -Isrc/ -fr=obj_firmware/am571x/clpru_0 -fs=obj_firmware/am571x/clpru_0 --preproc_dependency="emac_MII_Rcv.d" src/emac_MII_Rcv.asm

${CGT_PRU_DIR}/bin/clpru -DMAKEFILE_BUILD -v3 -g --endian=little --diag_wrap=off --diag_warning=225 --display_error_number --hardware_mac=on --preproc_with_compile -eo.opru   -DPRU0 -Dpru0    -DSOC_AM571x -I/opt/ti10/ccsv6/ccs_base/pru/include -I${CGT_PRU_DIR}/include -Isrc/ -fr=obj_firmware/am571x/clpru_0 -fs=obj_firmware/am571x/clpru_0 --preproc_dependency="emac_MII_Xmt.d" src/emac_MII_Xmt.asm

${CGT_PRU_DIR}/bin/clpru -DMAKEFILE_BUILD -v3 -g --endian=little --diag_wrap=off --diag_warning=225 --display_error_number --hardware_mac=on --preproc_with_compile -eo.opru   -DPRU0 -Dpru0    -DSOC_AM571x -I/opt/ti10/ccsv6/ccs_base/pru/include -I${CGT_PRU_DIR}/include -Isrc/ -fr=obj_firmware/am571x/clpru_0 -fs=obj_firmware/am571x/clpru_0 --preproc_dependency="emac_statistics.d" src/emac_statistics.asm

${CGT_PRU_DIR}/bin/clpru -DMAKEFILE_BUILD -v3 -g --endian=little --diag_wrap=off --diag_warning=225 --display_error_number --hardware_mac=on --preproc_with_compile -eo.opru   -DPRU0 -Dpru0    -DSOC_AM571x -I/opt/ti10/ccsv6/ccs_base/pru/include -I${CGT_PRU_DIR}/include -Isrc/ -fr=obj_firmware/am571x/clpru_0 -fs=obj_firmware/am571x/clpru_0 --preproc_dependency="emac_tts.d" src/emac_tts.asm


${CGT_PRU_DIR}/bin/clpru -v3 -g --endian=little --define=am571x --diag_wrap=off --diag_warning=225 --display_error_number --hardware_mac=on -z --stack_size=0 --heap_size=0 --reread_libs --warn_sections -I${CGT_PRU_DIR}/include -I${CGT_PRU_DIR}/lib --define=PRU0 --define=pru0 --entry_point=micro_scheduler    obj_firmware/am571x/clpru_0/micro_scheduler.opru  obj_firmware/am571x/clpru_0/emac_MII_Rcv.opru  obj_firmware/am571x/clpru_0/emac_MII_Xmt.opru  obj_firmware/am571x/clpru_0/emac_statistics.opru  obj_firmware/am571x/clpru_0/emac_tts.opru src/pru.cmd -o obj_firmware/am571x/clpru_0/icss_dualemac_PRU0.out -m obj_firmware/am571x/clpru_0/icss_dualemac_PRU0.map --xml_link_info="obj_firmware/am571x/clpru_0/icss_dualemac_PRU0_linkInfo.xml" -l${CGT_PRU_DIR}/lib/libc.a


${CGT_PRU_DIR}/bin/hexpru src/PRU0_to_ARM.cmd obj_firmware/am571x/clpru_0/icss_dualemac_PRU0.out -o bin_firmware/am571x/icss_dualemac_PRU0.bin

${CGT_PRU_DIR}/bin/clpru -DMAKEFILE_BUILD -v3 -g --endian=little --diag_wrap=off --diag_warning=225 --display_error_number --hardware_mac=on --preproc_with_compile -eo.opru   -DPRU1 -Dpru1    -DSOC_AM571x -I/opt/ti10/ccsv6/ccs_base/pru/include -I${CGT_PRU_DIR}/include -Isrc/ -fr=obj_firmware/am571x/clpru_1 -fs=obj_firmware/am571x/clpru_1 --preproc_dependency="micro_scheduler.d" src/micro_scheduler.asm

${CGT_PRU_DIR}/bin/clpru -DMAKEFILE_BUILD -v3 -g --endian=little --diag_wrap=off --diag_warning=225 --display_error_number --hardware_mac=on --preproc_with_compile -eo.opru   -DPRU1 -Dpru1    -DSOC_AM571x -I/opt/ti10/ccsv6/ccs_base/pru/include -I${CGT_PRU_DIR}/include -Isrc/ -fr=obj_firmware/am571x/clpru_1 -fs=obj_firmware/am571x/clpru_1 --preproc_dependency="emac_MII_Rcv.d" src/emac_MII_Rcv.asm

${CGT_PRU_DIR}/bin/clpru -DMAKEFILE_BUILD -v3 -g --endian=little --diag_wrap=off --diag_warning=225 --display_error_number --hardware_mac=on --preproc_with_compile -eo.opru   -DPRU1 -Dpru1    -DSOC_AM571x -I/opt/ti10/ccsv6/ccs_base/pru/include -I${CGT_PRU_DIR}/include -Isrc/ -fr=obj_firmware/am571x/clpru_1 -fs=obj_firmware/am571x/clpru_1 --preproc_dependency="emac_MII_Xmt.d" src/emac_MII_Xmt.asm

${CGT_PRU_DIR}/bin/clpru -DMAKEFILE_BUILD -v3 -g --endian=little --diag_wrap=off --diag_warning=225 --display_error_number --hardware_mac=on --preproc_with_compile -eo.opru   -DPRU1 -Dpru1    -DSOC_AM571x -I/opt/ti10/ccsv6/ccs_base/pru/include -I${CGT_PRU_DIR}/include -Isrc/ -fr=obj_firmware/am571x/clpru_1 -fs=obj_firmware/am571x/clpru_1 --preproc_dependency="emac_statistics.d" src/emac_statistics.asm

${CGT_PRU_DIR}/bin/clpru -DMAKEFILE_BUILD -v3 -g --endian=little --diag_wrap=off --diag_warning=225 --display_error_number --hardware_mac=on --preproc_with_compile -eo.opru   -DPRU1 -Dpru1    -DSOC_AM571x -I/opt/ti10/ccsv6/ccs_base/pru/include -I${CGT_PRU_DIR}/include -Isrc/ -fr=obj_firmware/am571x/clpru_1 -fs=obj_firmware/am571x/clpru_1 --preproc_dependency="emac_tts.d" src/emac_tts.asm


${CGT_PRU_DIR}/bin/clpru -v3 -g --endian=little --define=am571x --diag_wrap=off --diag_warning=225 --display_error_number --hardware_mac=on -z --stack_size=0 --heap_size=0 --reread_libs --warn_sections -I${CGT_PRU_DIR}/include -I${CGT_PRU_DIR}/lib --define=PRU1 --define=pru1 --entry_point=micro_scheduler    obj_firmware/am571x/clpru_1/micro_scheduler.opru  obj_firmware/am571x/clpru_1/emac_MII_Rcv.opru  obj_firmware/am571x/clpru_1/emac_MII_Xmt.opru  obj_firmware/am571x/clpru_1/emac_statistics.opru  obj_firmware/am571x/clpru_1/emac_tts.opru src/pru.cmd -o obj_firmware/am571x/clpru_1/icss_dualemac_PRU1.out -m obj_firmware/am571x/clpru_1/icss_dualemac_PRU1.map --xml_link_info="obj_firmware/am571x/clpru_1/icss_dualemac_PRU1_linkInfo.xml" -l${CGT_PRU_DIR}/lib/libc.a

${CGT_PRU_DIR}/bin/hexpru src/PRU1_to_ARM.cmd obj_firmware/am571x/clpru_1/icss_dualemac_PRU1.out -o bin_firmware/am571x/icss_dualemac_PRU1.bin





# ******************************************************************************
# * FILE PURPOSE: Compilation of Host DSP application 
# ******************************************************************************

"${CGT_C66x_DIR}/bin/cl6x" -mv6600 -g --define=SOC_AM571x --define=idkAM571x --define=USE_BIOS --define=C66X --diag_warning=225 --diag_warning=994 --diag_warning=262 --diag_suppress=1111 --diag_suppress=827 --diag_suppress=824 --diag_suppress=837 --diag_suppress=1037 --diag_suppress=195 --diag_suppress=77 --diag_suppress=232 --diag_wrap=off --display_error_number --exit_hook=ti_utils_exit --exit_parm=address --entry_hook=ti_utils_entry --entry_parm=address -z -m"ICSS_EMAC_BasicExample_idkAM571x_wSoCLib_C66Testproject.map" -i"${CGT_C66x_DIR}/lib" -i"${CGT_C66x_DIR}/include" --reread_libs --display_error_number --diag_wrap=off --warn_sections --xml_link_info="ICSS_EMAC_BasicExample_idkAM571x_wSoCLib_C66Testproject_linkInfo.xml" --rom_model --strict_compatibility=on -o "ICSS_EMAC_BasicExample_idkAM571x_wSoCLib_C66Testproject.out" "./icss_emacFwConfig.obj" "./main_dsp.obj" "./test_common_utils.obj" -l"configPkg/linker.cmd" -l"bin_firmware/am571x/icss_dualemac_PRU0.bin" -l"bin_firmware/am571x/icss_dualemac_PRU1.bin" -l"./lnk.cmd" -llibc.a 
