;******************************************************************************
;+--------------------------------------------------------------------------+**
;|                            ****                                          |**
;|                            ****                                          |**
;|                            ******o***                                    |**
;|                      ********_;/_****                                   |**
;|                      ***** /_;_/ ****                                   |**
;|                       ** ** (__/ ****                                    |**
;|                           *********                                      |**
;|                            ****                                          |**
;|                            ***                                           |**
;|                                                                          |**
;|         Copyright (c) 1998-2012 Texas Instruments Incorporated           |**
;|                        ALL RIGHTS RESERVED                               |**
;|                                                                          |**
;| Permission is hereby granted to licensees of Texas Instruments           |**
;| Incorporated (TI) products to use this computer program for the sole     |**
;| purpose of implementing a licensee product based on TI products.         |**
;| No other rights to reproduce, use, or disseminate this computer          |**
;| program, whether in part or in whole, are granted.                       |**
;|                                                                          |**
;| TI makes no representation or warranties with respect to the             |**
;| performance of this computer program, and specifically disclaims         |**
;| any responsibility for any damages, special or consequential,            |**
;| connected with the use of this program.                                  |**
;|                                                                          |**
;+--------------------------------------------------------------------------+**
;*****************************************************************************/
; file:   emac_MII_Xmt.hp
;
; brief:  Defines and macros to be used by Xmt task.
;
;
;  (C) Copyright 2012, Texas Instruments, Inc
;
;	Version		Description								Author
;
; 	0.1     	Created									Amit Shah
;	0.2 		Updated for Common Baseline				Anjandeep Sahni
	
	.if !$isdefed("__mii_xmt_hp")	
__mii_xmt_hp	.set	1	
	
	.include "icss_intc_regs.h"
	
MII_CONFIG	.set	0x4a310000	
host_if_mac	.set	0x10	
	.asg	R2, BUFFER	
buffer_ptr	.set	0x8	
	.asg	R11.w0, loop_cnt	
	
	.if $isdefed("xmt_debug")	
#define Debug_base			R11
#define debug_offset 		R12.w0
#define Debug_reg			R12.w2
	.endif
	
QUEUE_DESP_BASE	.set				ICSS_SHARED_CONST				 ; buffer need to be in consecutive register space
	.asg	R1.b3, TX_DATA_POINTER	
	
; MII transmit structure definition   -- TBD
;.struct MII_TX_DESC
	
;.ends
	
;;//////saved in scratch pad bank id 11 for context saving//////////
	.asg	R13, MII_TX_CONTEXT	
	.asg	R13.t0, PACKET_FROM_HOST			;1: from host, 0: from port 1
	.asg	R13.t1, INCREMENT_WRK_BUFFER_DESC_OFFSET	
	.asg	R13.t2, PACKET_FROM_COLL_QUEUE	
	.asg	R13.b1, BYTES_TRANSFERRED_IN_LAST_CALL	
	.asg	R13.w2, QUEUE_DESC_OFFSET	
	.asg	R14.w0, BYTE_CNT			;cnt for number of byte transferred in the packet
	.asg	R14.w2, Packet_Length			;length of the packet
	.asg	R15.w0, BUFFER_DESC_OFFSET	
	.asg	R15.w2, BUFFER_INDEX	
	.asg	R16.w0, BUFFER_OFFSET	
	.asg	R16.w2, TOP_MOST_BUFFER_INDEX	
	.asg	R17.w0, BASE_BUFFER_DESC_OFFSET	
	.asg	R17.w2, TOP_MOST_BUFFER_DESC_OFFSET			; offset of the top most buffer desc for the selected queue
;;/////////////////////////////////////////////////////////
	
	.asg	R4.w0, TX_CONTEXT_OFFSET	
	
	.asg	R11, BUFFER_DESC_REG	
	.asg	R10.w0, block_size	
	.asg	R10.b2, FREE_SPACE_IN_FIFO	
	.asg	R10.b3, size	
	
	.asg	R30.b0, TX_DATA_BYTE	
	.asg	R30.w0, TX_DATA_WORD	
	.asg	R30, TX_DATA_DOUBLE_WORD	
	.asg	R30.w2, TX_DATA_WORD_MASK	
	
QUEUE_DESC_REG	.sassign	 R2	,	struct_queue	
	
;-----------------------------------
; Macro Name: M_XMT_RX_EOF_CHECK_AM335x
; Description: Check for RX EOF on AM335x.
; Input Parameters: none
; Output Parameters: none
;-----------------------------------
M_XMT_RX_EOF_CHECK_AM335x	 .macro 		EOF_LABEL
	.if $isdefed("PRU0")	
	QBBS	EOF_LABEL, R31, 30	 ;replaced: QBBS	EOF_LABEL, R31.t30 ; Port0 Rx EOF
	.else
	QBBS	EOF_LABEL, R31, 31	 ;replaced: QBBS	EOF_LABEL, R31.t31 ; Port1 Rx EOF
	.endif
	.endm
	
;-----------------------------------
; Macro Name: M_XMT_RX_EOF_CHECK_AM571x
; Description: Check for RX EOF on AM571x.
; Input Parameters: none
; Output Parameters: none
;-----------------------------------
M_XMT_RX_EOF_CHECK_AM571x	 .macro 		EOF_LABEL
	QBBS	EOF_LABEL, R31, 20	 ;replaced: QBBS	EOF_LABEL, R31.t20 ; Port Rx EOF
	.endm
	
;-----------------------------------
; Macro Name: M_XMT_GET_TXSOF_AM335x
; Description: Get TX SOF on AM335x for fill level calculation.
; Input Parameters: none
; Output Parameters: none
;-----------------------------------
M_XMT_GET_TXSOF_AM335x	 .macro
	; Check if there is enough space in TX FIFO. To avoid TX Overflow.
	; Port TX SOF capture for port 1 (PRU1) and port 2 (PRU0) - 2 port config.
	.if $isdefed("PRU0")	
	LBCO	&TEMP_REG_3, IEP_CONST, CAP_RISE_TX_SOF_PORT1_OFFSET, 4	
	.else
	LBCO	&TEMP_REG_3, IEP_CONST, CAP_RISE_TX_SOF_PORT2_OFFSET, 4	
	.endif
	.endm
	
;-----------------------------------
; Macro Name: M_XMT_FILL_LEVEL_CALC_AM335x
; Description: Fill level calculation on AM335x.
; Input Parameters: none
; Output Parameters: none
;-----------------------------------
M_XMT_FILL_LEVEL_CALC_AM335x	 .macro
	LBCO	&TEMP_REG_1, IEP_CONST, IEP_COUNTER_OFFSET, 4	
	QBGE	iep_wrapped?, TEMP_REG_1, TEMP_REG_3	; branch if current time is less than SOF time stamp
	SUB	TEMP_REG_1, TEMP_REG_1, TEMP_REG_3	
	JMP	NO_IEP_WRAP?	
iep_wrapped?:
	.if $isdefed("TTS")	
	LDI	TEMP_REG_4.w0 , ICSS_EMAC_TTS_IEP_MAX_VAL & 0xFFFF
	LDI	TEMP_REG_4.w2 , ICSS_EMAC_TTS_IEP_MAX_VAL >> 16
	.else
	LDI	TEMP_REG_4.w0 , 0xffffffff & 0xFFFF
	LDI	TEMP_REG_4.w2 , 0xffffffff >> 16
	.endif	;TTS
	SUB	TEMP_REG_4, TEMP_REG_4, TEMP_REG_3	; total bytes sent is time stamp till end of IEP counter + current time
	ADD	TEMP_REG_1, TEMP_REG_4, TEMP_REG_1	
NO_IEP_WRAP?:
	LSR	TEMP_REG_1, TEMP_REG_1, 4	;	Divide by 16
	DIVU5	TEMP_REG_1, TEMP_REG_2, TEMP_REG_3	;	Again divide it by 5 .. divided by 80ns for 100 Mbps mode
	QBBS	XMT_100Mbps_Mode?, R23, 7	 ;replaced: QBBS	XMT_100Mbps_Mode, TX_PHY_SPEED 
	LSR	TEMP_REG_3, TEMP_REG_3, 1	; Divide by 2
	AND TEMP_REG_1 , TEMP_REG_3 , TEMP_REG_3
	DIVU5	TEMP_REG_1, TEMP_REG_2, TEMP_REG_3	; Divide by 5  .. divided by 800ns for 10 Mbps mode
XMT_100Mbps_Mode?:
	ADD	TEMP_REG_4, BYTE_CNT, 8	
	SUB	TEMP_REG_1, TEMP_REG_4, TEMP_REG_3	; = Fill level
	QBLT	error_in_fill_level, TEMP_REG_1.b0, 64	; Overflow situation. Reset FIFO and stop further transmission.
	RSB	FREE_SPACE_IN_FIFO, TEMP_REG_1.b0, 64	; Compute the free space in Tx Fifo
	.endm
	
;-----------------------------------
; Macro Name: M_XMT_FILL_LEVEL_CALC_AM571x
; Description: Fill level calculation on AM571x.
; Input Parameters: none
; Output Parameters: none
;-----------------------------------
M_XMT_FILL_LEVEL_CALC_AM571x	 .macro
	.if $isdefed("PRU0")	
	LBCO	&TEMP_REG_1.b0, MII_RT_CFG_CONST, 0x68, 4	; = Fill level
	.else
	LBCO	&TEMP_REG_1.b0, MII_RT_CFG_CONST, 0x6C, 4	
	.endif
	LSR	TEMP_REG_1, TEMP_REG_1, 1	;Divide the fill level by 2 to convert it in bytes
	M_XMT_UNDER_OVER_FLOW_CHECK_AM571x
	RSB	FREE_SPACE_IN_FIFO, TEMP_REG_1.b0, 96	;Compute the free space in Tx Fifo
	.endm
	
;-----------------------------------
; Macro Name: M_XMT_INSERT_CRC_AM335x
; Description: Insert the CRC in outgoing frame on AM335x.
; Input Parameters: none
; Output Parameters: none
;-----------------------------------
M_XMT_INSERT_CRC_AM335x	 .macro
	M_PUSH_CRC_MSWORD
	LDI	TEMP_REG_4.b2, 4
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;compiler bug
;;	WAIT	TEMP_REG_4.b2	
	WAIT	R3.b2	
	M_PUSH_CRC_LSWORD
	.endm
	
;-----------------------------------
; Macro Name: M_XMT_INSERT_CRC_AM571x
; Description: Insert the CRC in outgoing frame on AM571x.
; Input Parameters: none
; Output Parameters: none
;-----------------------------------
M_XMT_INSERT_CRC_AM571x	 .macro
	LDI	R31.w2 , 0x2C00
	.endm
	
;-----------------------------------
; Macro Name: M_XMT_UNDER_OVER_FLOW_CHECK_AM571x
; Description: Check underflow and overflow flags on AM571x.
; Input Parameters: none
; Output Parameters: none
;-----------------------------------
M_XMT_UNDER_OVER_FLOW_CHECK_AM571x	 .macro
	QBGE	CHECK_UNDERFLOW?, TEMP_REG_1.b0, 96	
	;Overflow has occured. Increment counter and reset the FIFO.
	;We cannot use INTC because of harware issue.
	LDI	TEMP_REG_2.w0 , TX_OVERFLOW_COUNTER
	LBCO	&TEMP_REG_3, PRU_DMEM_ADDR, TEMP_REG_2.w0, 4	
	ADD	TEMP_REG_3, TEMP_REG_3, 1	
	SBCO	&TEMP_REG_3, PRU_DMEM_ADDR, TEMP_REG_2.w0, 4	
	JMP		error_in_fill_level
CHECK_UNDERFLOW?:
	LDI	TEMP_REG_2.w0 , ICSS_INTC_SECR1
	LBCO	&TEMP_REG_3, ICSS_INTC_CONST, TEMP_REG_2.w0, 4	
	.if $isdefed("PRU0")	
	QBBC	NO_UNDERFLOW?, TEMP_REG_3, 7	 ;replaced: QBBC  NO_UNDERFLOW, TEMP_REG_3.TX0_UNDERFLOW 
	.else
	QBBC	NO_UNDERFLOW?, TEMP_REG_3, 19	 ;replaced: QBBC  NO_UNDERFLOW, TEMP_REG_3.TX1_UNDERFLOW 
	.endif
	;Underflow bit is set, clear the error and reset the FIFO.
	LDI	TEMP_REG_3 , 0
	.if $isdefed("PRU0")	
	SET	TEMP_REG_3 , TEMP_REG_3 , 7 
	.else
	SET	TEMP_REG_3 , TEMP_REG_3 , 19 
	.endif
	SBCO	&TEMP_REG_3, ICSS_INTC_CONST, TEMP_REG_2.w0, 4	
	LDI	TEMP_REG_2.w0 , TX_UNDERFLOW_COUNTER
	LBCO	&TEMP_REG_3, PRU_DMEM_ADDR, TEMP_REG_2.w0, 4	
	ADD	TEMP_REG_3, TEMP_REG_3, 1	
	SBCO	&TEMP_REG_3, PRU_DMEM_ADDR, TEMP_REG_2.w0, 4	
	JMP		error_in_fill_level
NO_UNDERFLOW?:
	.endm
	
	.endif	;__mii_xmt_hp
