;******************************************************************************
;+--------------------------------------------------------------------------+**
;|                            ****                                          |**
;|                            ****                                          |**
;|                            ******o***                                    |**
;|                      ********_;/_****                                   |**
;|                      ***** /_;_/ ****                                   |**
;|                       ** ** (__/ ****                                    |**
;|                           *********                                      |**
;|                            ****                                          |**
;|                            ***                                           |**
;|                                                                          |**
;|         Copyright (c) 1998-2012 Texas Instruments Incorporated           |**
;|                        ALL RIGHTS RESERVED                               |**
;|                                                                          |**
;| Permission is hereby granted to licensees of Texas Instruments           |**
;| Incorporated (TI) products to use this computer program for the sole     |**
;| purpose of implementing a licensee product based on TI products.         |**
;| No other rights to reproduce, use, or disseminate this computer          |**
;| program, whether in part or in whole, are granted.                       |**
;|                                                                          |**
;| TI makes no representation or warranties with respect to the             |**
;| performance of this computer program, and specifically disclaims         |**
;| any responsibility for any damages, special or consequential,            |**
;| connected with the use of this program.                                  |**
;|                                                                          |**
;+--------------------------------------------------------------------------+**
;*****************************************************************************/
; file:   emac_statistics.p
;
; brief:  Statistics task.
;
;
;  (C) Copyright 2012, Texas Instruments, Inc
;
;	Version		Description								Author
;
; 	0.1     	Created									
	
	.include "icss_emacSwitch.h"
	.include "emac_MII_Rcv.h"
        .include "emac_MII_Xmt.h"
        .include "icss_miirt_regs.h"

        .global  STATS_TASK


	.asg	R8, STATS_REG 	; stores current stats counter offset
	
	.asg	R9, RX_STATS_REG	
	.asg	R5, PACKET_SIZE	
	.asg	R6.b0, RX_PACKET_SIZE	
	.asg	R9.w0, RX_PKT_SIZE_REG	
	
RX_TX_BIN_DIFF	.set	0x20	
	
	.asg	R3, STAT_TEMP_REG	
	.asg	R2, INTC_RAW_OFFSET	
	
RX_TX_BINNING_OFFSET	.set	0x18	
	
;-----------------------------------
;CYCLE BUDGET : 
;TX_TASK ~30 cycles
;RX_TASK (store and forward) ~30 cycles
;RX_TASK (cut through) ~57 cycles
;-----------------------------------
	
	
;-----------------------------------
; Macro Name: INCREMENT_STAT_COUNTER
; Description: Read stat value from memory, increment by 1 and write back
; Input Parameters: none
; Output Parameters: none
;-----------------------------------
INCREMENT_STAT_COUNTER	 .macro
	LBCO	&R2, PRU_DMEM_ADDR, STATS_REG, 4	
	ADD	R2, R2, 1	
	SBCO	&R2, PRU_DMEM_ADDR, STATS_REG, 4	
	.endm
	
; TX_STAT_PEND - Set by TX_LB, cleared by TX_STATS_TASK
; RX_STAT_PEND - Set by RX_LB, cleared by RX_STATS_TASK
	
STATS_TASK:
	AND L1_CALL_REG , CALL_REG , CALL_REG
	QBBC	RX_STAT_TASK, R23, 2	 ;replaced: QBBC 		RX_STAT_TASK, TX_STAT_PEND 
	
	LDI	R4 , STATISTICS_OFFSET
	LDI	SHIFT_REG, SHIFT_NONE	
	.if $isdefed("PRU0")	
	XIN	BANK1, &MII_TX_CONTEXT, 8	
	.else
	XIN	BANK2, &MII_TX_CONTEXT, 8	
	.endif
	
;save packet length
	ADD	Packet_Length, Packet_Length, 4	
	
	
TX_GOOD_FRAMES:
	ADD	STATS_REG, R4, TX_BYTE_CNT_OFFSET	
	LBCO	&R2, PRU_DMEM_ADDR, STATS_REG, 4	
	ADD	R2, R2, Packet_Length	
	SBCO	&R2, PRU_DMEM_ADDR, STATS_REG, 4	
	
TX_64_FRAME:
	QBLT	TX_65_127_BYTE_FRAME, Packet_Length, 64	
	ADD	STATS_REG, R4, TX_64_BYTE_FRAME_OFFSET	
	JMP 		ADD_TX_BINNING_COUNTER
	
	;65 < packet size < 127
TX_65_127_BYTE_FRAME:
	QBLT	TX_128_255_BYTE_FRAME, Packet_Length, 127	
	ADD	STATS_REG, R4, TX_65_127_BYTE_FRAME_OFFSET	
	JMP 		ADD_TX_BINNING_COUNTER
	
	;128 < packet size < 255
TX_128_255_BYTE_FRAME:
	QBLT	TX_256_511_BYTE_FRAME, Packet_Length, 255	
	ADD	STATS_REG, R4, TX_128_255_BYTE_FRAME_OFFSET	
	JMP 		ADD_TX_BINNING_COUNTER
	
	;256 < packet size < 511
TX_256_511_BYTE_FRAME:
	LDI	STAT_TEMP_REG, 511	
	QBLT	TX_512_1023_BYTE_FRAME, Packet_Length, STAT_TEMP_REG	
	ADD	STATS_REG, R4, TX_256_511_BYTE_FRAME_OFFSET	
	JMP 		ADD_TX_BINNING_COUNTER
	
	;512 < packet size < 1023
TX_512_1023_BYTE_FRAME:
	LDI	STAT_TEMP_REG, 1023	
	QBLT	TX_1024_MAX_BYTE_FRAME, Packet_Length, STAT_TEMP_REG	
	ADD	STATS_REG, R4, TX_512_1023_BYTE_FRAME_OFFSET	
	JMP 		ADD_TX_BINNING_COUNTER
	
	; packet size < 1024
TX_1024_MAX_BYTE_FRAME:
	ADD	STATS_REG, R4, TX_1024_MAX_BYTE_FRAME_OFFSET	
	
ADD_TX_BINNING_COUNTER:
	INCREMENT_STAT_COUNTER
	
COUNT_TX_BC_FRAMES:
	QBBC	COUNT_TX_MC_FRAMES, R22, 26	 ;replaced: QBBC        COUNT_TX_MC_FRAMES, TX_BC_FRAME 
	ADD	STATS_REG, R4, TX_BC_FRAMES_OFFSET	
	CLR	R22 , R22 , 26 
	QBA         COUNT_TX_GOOD_FRAMES
	
COUNT_TX_MC_FRAMES:
	QBBC	COUNT_TX_UC_FRAMES, R22, 25	 ;replaced: QBBC        COUNT_TX_UC_FRAMES, TX_MC_FRAME 
	ADD	STATS_REG, R4, TX_MC_FRAMES_OFFSET	
	CLR	R22 , R22 , 25 
	QBA         COUNT_TX_GOOD_FRAMES
	
COUNT_TX_UC_FRAMES:
	ADD	STATS_REG, R4, TX_UC_FRAMES_OFFSET	
	
COUNT_TX_GOOD_FRAMES:
	INCREMENT_STAT_COUNTER
	
TX_STAT_CLR:
	CLR	R23 , R23 , 2 
	
RX_STAT_TASK:
	QBBC	STAT_DONE, R23, 3	 ;replaced: QBBC 		STAT_DONE, RX_STAT_PEND 
	;load the size
	LDI	R2 , RX_PKT_SIZE_OFFSET
	LBCO	&RX_PKT_SIZE_REG, PRU_DMEM_ADDR, R2, 2	
	
	
RX_GOOD_FRAMES:
	LDI	R4 , STATISTICS_OFFSET
	QBBC	COUNT_RX_MC_FRAMES, R22, 28	 ;replaced: QBBC        COUNT_RX_MC_FRAMES, RX_BC_FRAME 
	ADD	STATS_REG, R4, RX_BC_FRAMES_OFFSET	
	QBA         RX_INCREMENT_COUNTER
	
COUNT_RX_MC_FRAMES:
	QBBC	COUNT_RX_UC_FRAMES, R22, 27	 ;replaced: QBBC        COUNT_RX_UC_FRAMES, RX_MC_FRAME 
	ADD	STATS_REG, R4, RX_MC_FRAMES_OFFSET	
	QBA         RX_INCREMENT_COUNTER
	
COUNT_RX_UC_FRAMES:
	ADD	STATS_REG, R4, RX_UC_FRAMES_OFFSET	
	
RX_INCREMENT_COUNTER:
	INCREMENT_STAT_COUNTER
	
;Add byte count
	ADD	STATS_REG, R4, RX_BYTE_CNT_OFFSET	
	LBCO	&R2, PRU_DMEM_ADDR, STATS_REG, 4	
	ADD	R2, R2, RX_PKT_SIZE_REG	
	SBCO	&R2, PRU_DMEM_ADDR, STATS_REG, 4	
	
RX_64_FRAME:
	QBLT    	RX_65_127_BYTE_FRAME, MII_RCV.byte_cntr, 64
	ADD	STATS_REG, R4, RX_64_BYTE_FRAME_OFFSET	
	JMP 		ADD_RX_BINNING_COUNTER
	
	;65 < packet size < 127
RX_65_127_BYTE_FRAME:
	QBLT	RX_128_255_BYTE_FRAME, RX_PKT_SIZE_REG, 127	
	ADD	STATS_REG, R4, RX_65_127_BYTE_FRAME_OFFSET	
	JMP 		ADD_RX_BINNING_COUNTER
	
	;128 < packet size < 255
RX_128_255_BYTE_FRAME:
	QBLT	RX_256_511_BYTE_FRAME, RX_PKT_SIZE_REG, 255	
	
	ADD	STATS_REG, R4, RX_128_255_BYTE_FRAME_OFFSET	
	JMP 		ADD_RX_BINNING_COUNTER
	
	;256 < packet size < 511
RX_256_511_BYTE_FRAME:
	LDI	STAT_TEMP_REG, 511	
	QBLT	RX_512_1023_BYTE_FRAME, RX_PKT_SIZE_REG, STAT_TEMP_REG	
	ADD	STATS_REG, R4, RX_256_511_BYTE_FRAME_OFFSET	
	JMP 		ADD_RX_BINNING_COUNTER
	
	;512 < packet size < 1023
RX_512_1023_BYTE_FRAME:
	LDI	STAT_TEMP_REG, 1023	
	QBLT	RX_1024_MAX_BYTE_FRAME, RX_PKT_SIZE_REG, STAT_TEMP_REG	
	ADD	STATS_REG, R4, RX_512_1023_BYTE_FRAME_OFFSET	
	JMP 		ADD_RX_BINNING_COUNTER
	
	; packet size < 1024
RX_1024_MAX_BYTE_FRAME:
	ADD	STATS_REG, R4, RX_1024_MAX_BYTE_FRAME_OFFSET	
	
ADD_RX_BINNING_COUNTER:
	INCREMENT_STAT_COUNTER
	AND STAT_TEMP_REG , STATS_REG , STATS_REG
	
RX_STAT_CLR:
	CLR	R22 , R22 , 28 
	CLR	R22 , R22 , 27 
	CLR	R23 , R23 , 3 
	QBA         STAT_DONE
	
CLEAR_AND_EXIT_STATS:
	
STAT_DONE:
	AND CALL_REG , L1_CALL_REG , L1_CALL_REG
	JMP	CALL_REG	
	;JMP		TASK_EXECUTION_FINISHED
