;******************************************************************************
;+--------------------------------------------------------------------------+**
;|                            ****                                          |**
;|                            ****                                          |**
;|                            ******o***                                    |**
;|                      ********_;/_****                                   |**
;|                      ***** /_;_/ ****                                   |**
;|                       ** ** (__/ ****                                    |**
;|                           *********                                      |**
;|                            ****                                          |**
;|                            ***                                           |**
;|                                                                          |**
;|         Copyright (c) 1998-2013 Texas Instruments Incorporated           |**
;|                        ALL RIGHTS RESERVED                               |**
;|                                                                          |**
;| Permission is hereby granted to licensees of Texas Instruments           |**
;| Incorporated (TI) products to use this computer program for the sole     |**
;| purpose of implementing a licensee product based on TI products.         |**
;| No other rights to reproduce, use, or disseminate this computer          |**
;| program, whether in part or in whole, are granted.                       |**
;|                                                                          |**
;| TI makes no representation or warranties with respect to the             |**
;| performance of this computer program, and specifically disclaims         |**
;| any responsibility for any damages, special or consequential,            |**
;| connected with the use of this program.                                  |**
;|                                                                          |**
;+--------------------------------------------------------------------------+**
;*****************************************************************************/
; file:   firmware_version.h
;
; brief:  ICSS Ethernet MAC Firmware Version Control
;			
;
;  (C) Copyright 2013, Texas Instruments, Inc
;
;	Version		Description								Author
;
; 	0.1     	Created									Thomas Mauer
;	0.2			Updated for Common Baseline				Anjandeep Sahni
	
	.if !$isdefed("__firmware_version_h")	
__firmware_version_h	.set	1	
	
; ICSS_FIRMWARE_RELEASE_1: 
; bit 31..16 reserved
; bit15..8	device number
FIRMWARE_DEVICE_AM335x	.set	0	
FIRMWARE_DEVICE_AM571x	.set	1	
; bit7..0	protocol type
FIRMWARE_PROTOCOL_TYPE_ETHERNET_MAC	.set	0x11	
	
; ICSS_FIRMWARE_RELEASE_2:
; bit31		release or internal version
FIRMWARE_VERSION_INTERNAL	.set	0	
FIRMWARE_VERSION_RELEASE	.set	1	
; bit30..24	major version number									;For major IP changes.
FIRMWARE_VERSION_MAJOR	.set	0x03	
; bit23..16	minor version number									;For feature additions to firmware.
FIRMWARE_VERSION_MINOR	.set	0x01	
; bit15..0		build number											;For all other minor changes.
FIRMWARE_VERSION_BUILD	.set	0x04	
	
	.if $isdefed("SOC_AM335x")	
ICSS_FIRMWARE_RELEASE_1	.set		((FIRMWARE_DEVICE_AM335x << 8) | (FIRMWARE_PROTOCOL_TYPE_ETHERNET_MAC << 0)) 
	.endif
	.if $isdefed("SOC_AM571x")	
ICSS_FIRMWARE_RELEASE_1	.set		((FIRMWARE_DEVICE_AM571x << 8) | (FIRMWARE_PROTOCOL_TYPE_ETHERNET_MAC << 0)) 
	.endif
	
	.if $isdefed("DEBUG")	
ICSS_FIRMWARE_RELEASE_2	.set	 ((FIRMWARE_VERSION_INTERNAL << 31) | (FIRMWARE_VERSION_MAJOR << 24) | (FIRMWARE_VERSION_MINOR << 16) | (FIRMWARE_VERSION_BUILD << 0)) 
	.else
ICSS_FIRMWARE_RELEASE_2	.set	 ((FIRMWARE_VERSION_RELEASE << 31) | (FIRMWARE_VERSION_MAJOR << 24) | (FIRMWARE_VERSION_MINOR << 16) | (FIRMWARE_VERSION_BUILD << 0))
	.endif
	
	.endif	;__firmware_version_h
