;******************************************************************************
;+--------------------------------------------------------------------------+**
;|                            ****                                          |**
;|                            ****                                          |**
;|                            ******o***                                    |**
;|                      ********_;/_****                                   |**
;|                      ***** /_;_/ ****                                   |**
;|                       ** ** (__/ ****                                    |**
;|                           *********                                      |**
;|                            ****                                          |**
;|                            ***                                           |**
;|                                                                          |**
;|         Copyright (c) 1998-2010 Texas Instruments Incorporated           |**
;|                        ALL RIGHTS RESERVED                               |**
;|                                                                          |**
;| Permission is hereby granted to licensees of Texas Instruments           |**
;| Incorporated (TI) products to use this computer program for the sole     |**
;| purpose of implementing a licensee product based on TI products.         |**
;| No other rights to reproduce, use, or disseminate this computer          |**
;| program, whether in part or in whole, are granted.                       |**
;|                                                                          |**
;| TI makes no representation or warranties with respect to the             |**
;| performance of this computer program, and specifically disclaims         |**
;| any responsibility for any damages, special or consequential,            |**
;| connected with the use of this program.                                  |**
;|                                                                          |**
;+--------------------------------------------------------------------------+**
;*****************************************************************************/
; file:   icss_cntl_regs.hp
;
; brief:  ICSS Control Module Registers
;
;
;  (C) Copyright 2010, Texas Instruments, Inc
;
;	Version		Description								Author
;
; 	0.1     	Created									Vijaya Sarathy
	
	.if !$isdefed("__icss_cntl_regs_h")	
__icss_cntl_regs_h	.set	1	
	
; ==== PRU Control Module Registers Offsets (from PRUx_CNTL$..._BASE) ====
PRUx_CNTL_CONTROL_OFFSET	.set	0x0000	
PRUx_CNTL_STATUS_OFFSET	.set	0x0004	
PRUx_CNTL_WKUP_OFFSET	.set	0x0008	
PRUx_CNTL_CYCLE_COUNT_OFFSET	.set	0x000C	
PRUx_CNTL_STALL_COUNT_OFFSET	.set	0x0010	
PRUx_CNTL_CONST_IDX0_OFFSET	.set	0x0020	
PRUx_CNTL_CONST_IDX1_OFFSET	.set	0x0024	
PRUx_CNTL_CONST_PTR0_OFFSET	.set	0x0028	
PRUx_CNTL_CONST_PTR1_OFFSET	.set	0x002C	
	
; ==== PRU's own Control Module Registers ====
PRUx_CNTLSELF_CONTROL_REG	.set				(ICSS_CNTLSELF_BASE + PRUx_CNTL_CONTROL_OFFSET)
PRUx_CNTLSELF_STATUS_REG	.set				(ICSS_CNTLSELF_BASE + PRUx_CNTL_STATUS_OFFSET)
PRUx_CNTLSELF_WKUP_REG	.set					(ICSS_CNTLSELF_BASE + PRUx_CNTL_WKUP_OFFSET)
PRUx_CNTLSELF_CYCLE_COUNT_REG	.set			(ICSS_CNTLSELF_BASE + PRUx_CNTL_CYCLE_COUNT_OFFSET)
PRUx_CNTLSELF_STALL_COUNT_REG	.set			(ICSS_CNTLSELF_BASE + PRUx_CNTL_STALL_COUNT_OFFSET)
PRUx_CNTLSELF_CONST_IDX0_REG	.set			(ICSS_CNTLSELF_BASE + PRUx_CNTL_CONST_IDX0_OFFSET)
PRUx_CNTLSELF_CONST_IDX1_REG	.set			(ICSS_CNTLSELF_BASE + PRUx_CNTL_CONST_IDX1_OFFSET)
PRUx_CNTLSELF_CONST_PTR0_REG	.set			(ICSS_CNTLSELF_BASE + PRUx_CNTL_CONST_PTR0_OFFSET)
PRUx_CNTLSELF_CONST_PTR1_REg	.set			(ICSS_CNTLSELF_BASE + PRUx_CNTL_CONST_PTR1_OFFSET)
	
; ==== Peer PRU's Control Module Registers ====
PRUx_CNTLPEER_CONTROL_REG	.set				(ICSS_CNTLPEER_BASE + PRUx_CNTL_CONTROL_OFFSET)
PRUx_CNTLPEER_STATUS_REG	.set				(ICSS_CNTLPEER_BASE + PRUx_CNTL_STATUS_OFFSET)
PRUx_CNTLPEER_WKUP_REG	.set					(ICSS_CNTLPEER_BASE + PRUx_CNTL_WKUP_OFFSET)
PRUx_CNTLPEER_CYCLE_COUNT_REG	.set			(ICSS_CNTLPEER_BASE + PRUx_CNTL_CYCLE_COUNT_OFFSET)
PRUx_CNTLPEER_STALL_COUNT_REG	.set			(ICSS_CNTLPEER_BASE + PRUx_CNTL_STALL_COUNT_OFFSET)
PRUx_CNTLPEER_CONST_IDX0_REG	.set			(ICSS_CNTLPEER_BASE + PRUx_CNTL_CONST_IDX0_OFFSET)
PRUx_CNTLPEER_CONST_IDX1_REG	.set			(ICSS_CNTLPEER_BASE + PRUx_CNTL_CONST_IDX1_OFFSET)
PRUx_CNTLPEER_CONST_PTR0_REG	.set			(ICSS_CNTLPEER_BASE + PRUx_CNTL_CONST_PTR0_OFFSET)
PRUx_CNTLPEER_CONST_PTR1_REg	.set			(ICSS_CNTLPEER_BASE + PRUx_CNTL_CONST_PTR1_OFFSET)
	
	.endif	;__icss_cntl_regs_h
