;******************************************************************************
;+--------------------------------------------------------------------------+**
;|                            ****                                          |**
;|                            ****                                          |**
;|                            ******o***                                    |**
;|                      ********_;/_****                                   |**
;|                      ***** /_;_/ ****                                   |**
;|                       ** ** (__/ ****                                    |**
;|                           *********                                      |**
;|                            ****                                          |**
;|                            ***                                           |**
;|                                                                          |**
;|         Copyright (c) 1998-2010 Texas Instruments Incorporated           |**
;|                        ALL RIGHTS RESERVED                               |**
;|                                                                          |**
;| Permission is hereby granted to licensees of Texas Instruments           |**
;| Incorporated (TI) products to use this computer program for the sole     |**
;| purpose of implementing a licensee product based on TI products.         |**
;| No other rights to reproduce, use, or disseminate this computer          |**
;| program, whether in part or in whole, are granted.                       |**
;|                                                                          |**
;| TI makes no representation or warranties with respect to the             |**
;| performance of this computer program, and specifically disclaims         |**
;| any responsibility for any damages, special or consequential,            |**
;| connected with the use of this program.                                  |**
;|                                                                          |**
;+--------------------------------------------------------------------------+**
;*****************************************************************************/
; file:   icss_miirt_regs.hp
;
; brief:  ICSS MII_RT Module Registers
;
;
;  (C) Copyright 2010, Texas Instruments, Inc
;
;	Version		Description								Author
;
; 	0.1     	Created									Vijaya Sarathy
;	0.20		Added register primitives				tley
	
	.if !$isdefed("__icss_miirt_regs_h")	
__icss_miirt_regs_h	.set	1	
	
ICSS_MIIRT_RXCFG0	.set	0x0000	
ICSS_MIIRT_RXCFG1	.set	0x0004	
ICSS_MIIRT_RSVD0	.set	0x0008	
ICSS_MIIRT_TXCFG0	.set	0x0010	
ICSS_MIIRT_TXCFG1	.set	0x0014	
ICSS_MIIRT_RSVD1	.set	0x0018	
ICSS_MIIRT_TXCRC0	.set	0x0020	
ICSS_MIIRT_TXCRC1	.set	0x0024	
ICSS_MIIRT_TXIPG0	.set	0x0030	
ICSS_MIIRT_TXIPG1	.set	0x0034	
ICSS_MIIRT_PRS0	.set	0x0038	
ICSS_MIIRT_PRS1	.set	0x003c	
ICSS_MIIRT_RXFRMS0	.set	0x0040	
ICSS_MIIRT_RXFRMS1	.set	0x0044	
ICSS_MIIRT_RXPCNT0	.set	0x0048	
ICSS_MIIRT_RXPCNT1	.set	0x004C	
ICSS_MIIRT_RXERR0	.set	0x0050	
ICSS_MIIRT_RXERR1	.set	0x0054	
	
; Primitives
; ICSS_MIIRT_RXCFG0/1
RX_DISABLE	.set	0x00	
RX_ENABLE	.set	0x01	
RX_CUT_PREAMBLE	.set	0x04	
RX_MUX_SELECT_P0	.set	0x00	
RX_MUX_SELECT_P1	.set	0x08	
RX_L2_ENABLE	.set	0x10	
RX_BYTE_SWAP_ENABLE	.set	0x20	
RX_AUTO_FWD_PRE	.set	0x40	
	
; ICSS_MIIRT_TXCFG0/1
TX_DISABLE	.set	0x00	
TX_ENABLE	.set	0x01	
TX_AUTO_PREAMBLE	.set	0x02	
TX_EN_MODE	.set	0x04	
TX_BYTE_SWAP	.set	0x08	
TX_MUX_SELECT_PRU0	.set	0x000	
TX_MUX_SELECT_PRU1	.set	0x100	
TX_AUTO_SEQUENCE	.set	0x200	
TX_START_DELAY_0	.set	0x000000	
TX_START_DELAY_320	.set	0x00400000	
TX_START_DELAY_360	.set	0x00480000	
TX_START_DELAY_640	.set	0x00800000	
TX_START_DELAY_5120	.set	0x003F0000	
TX_CLK_DELAY_10ns	.set	0x00000000	
TX_CLK_DELAY_15ns	.set	0x10000000	
TX_CLK_DELAY_20ns	.set	0x20000000	
TX_CLK_DELAY_25ns	.set	0x30000000	
TX_CLK_DELAY_30ns	.set	0x40000000	
TX_CLK_DELAY_35ns	.set	0x50000000	
	
; Register settings for EMAC0 on port 0 - RX FIFO Mode
RXCFG0_EMAC0	.set	   	(RX_ENABLE | RX_CUT_PREAMBLE | RX_MUX_SELECT_P0 | RX_L2_ENABLE ) 
TXCFG0_EMAC0	.set		(TX_ENABLE | TX_AUTO_PREAMBLE | TX_MUX_SELECT_PRU0 | TX_START_DELAY_0 | TX_CLK_DELAY_10ns) 
	
; Register settings for EMAC1 on port 1 - RX FIFO Mode
RXCFG1_EMAC1	.set	   	(RX_ENABLE | RX_CUT_PREAMBLE | RX_MUX_SELECT_P1 | RX_L2_ENABLE ) 
TXCFG1_EMAC1	.set		(TX_ENABLE | TX_AUTO_PREAMBLE | TX_MUX_SELECT_PRU1 | TX_START_DELAY_0 | TX_CLK_DELAY_10ns) 
	
; Register settings for on the fly processing with cross connect - 360ns MII2MII delay
; Rx port0 -> PRU0 -> TX port1 
; RX port1 -> PRU1 -> TX port0
RXCFG0_OTF	.set	   	(RX_ENABLE | RX_CUT_PREAMBLE | RX_MUX_SELECT_P0 ) 
TXCFG0_OTF	.set			(TX_ENABLE | TX_AUTO_PREAMBLE | TX_MUX_SELECT_PRU1 | TX_START_DELAY_360 | TX_CLK_DELAY_10ns) 
RXCFG1_OTF	.set	   	(RX_ENABLE | RX_CUT_PREAMBLE | RX_MUX_SELECT_P1 ) 
TXCFG1_OTF	.set			(TX_ENABLE | TX_AUTO_PREAMBLE | TX_MUX_SELECT_PRU0 | TX_START_DELAY_360 | TX_CLK_DELAY_10ns) 
	
; Register settings for cut-through switch with cross connect - RX FIFO Mode
; Rx port0 -> PRU0 -> TX port1 
; RX port1 -> PRU1 -> TX port0
RXCFG0_CTS	.set	   	(RX_ENABLE | RX_CUT_PREAMBLE | RX_MUX_SELECT_P0 | RX_L2_ENABLE ) 
TXCFG0_CTS	.set			(TX_ENABLE | TX_AUTO_PREAMBLE | TX_MUX_SELECT_PRU1 | TX_START_DELAY_0 | TX_CLK_DELAY_10ns) 
RXCFG1_CTS	.set	   	(RX_ENABLE | RX_CUT_PREAMBLE | RX_MUX_SELECT_P1 | RX_L2_ENABLE ) 
TXCFG1_CTS	.set			(TX_ENABLE | TX_AUTO_PREAMBLE | TX_MUX_SELECT_PRU0 | TX_START_DELAY_0 | TX_CLK_DELAY_10ns) 
	
;R31 Status flags
	.asg	t16, D_DATA_READY_FLAG_BITNUM	
	.asg	t17, D_BYTE_READY_FLAG_BITNUM	
	.asg	t18, D_WORD_READY_FLAG_BITNUM	
	.asg	t19, D_RX_ERROR_FLAG_BITNUM	
	.asg	t20, D_EOF_FLAG_BITNUM	
	.asg	t21, D_SFD_FLAG_BITNUM	
	.asg	t22, D_SOF_FLAG_BITNUM	
	.asg	t23, D_ERROR_NIBBLE_FLAG_BITNUM	
	.asg	t24, D_CRC_ERR_FLAG_BITNUM	
	.asg	t25, D_RX_ERR_FLAG_BITNUM	
	.asg	t26, D_RX_MAX_PRE_CNT_ERR_FLAG_BITNUM	
	.asg	t27, D_RX_EOF_ERROR_FLAG_BITNUM	
	.asg	t28, D_RX_MAX_FRM_CNT_ERR_FLAG_BITNUM	
	.asg	t29, D_RX_MIN_FRM_CNT_ERR_FLAG_BITNUM	
	
	
D_DATA_READY_FLAG_MASK	.set			(1 << 0) 
D_BYTE_READY_FLAG_MASK	.set			(1 << 1) 
D_WORD_READY_FLAG_MASK	.set			(1 << 2) 
D_RX_ERROR_FLAG_MASK	.set			(1 << 3) 
D_EOF_FLAG_MASK	.set					(1 << 4) 
D_SFD_FLAG_MASK	.set					(1 << 5) 
D_SOF_FLAG_MASK	.set					(1 << 6) 
D_ERROR_NIBBLE_FLAG_MASK	.set		(1 << 7) 
D_CRC_ERR_FLAG_MASK	.set				(1 << 8) 
D_RX_ERR_FLAG_MASK	.set				(1 << 9) 
	
	
;R31 Command masks
	
D_TX_CRC_ERR	.set	0x8000	
D_RESET_TXFIFO	.set	0x4000	
D_TX_EOF	.set	0x2000	
D_PUSH_ERR_NIBBLE_CMD	.set	0x1000	
	
D_PUSH_CRC_MSWORD_CMD	.set	0x0800	
D_PUSH_CRC_LSWORD_CMD	.set	0x0400	
D_PUSH_TX_EOF_CMD	.set	0x0C00	
D_PUSH_WORD_CMD	.set	0x0200	
D_PUSH_BYTE_CMD	.set	0x0100	
	
	
D_RX_ERROR_CLEAR	.set	0x0080	
D_RX_SOF_CLEAR	.set	0x0040	
D_RX_SFD_CLEAR	.set	0x0020	
D_RX_EOF_CLEAR	.set	0x0010	
	
D_RESET_RXFIFO	.set	0x0004	
D_POP_WORD_CMD	.set	0x0002	
D_POP_BYTE_CMD	.set	0x0001	
	
D_PUSH_N_POP_BYTE_CMD	.set	               D_POP_BYTE_CMD | D_PUSH_BYTE_CMD 
D_PUSH_N_POP_WORD_CMD	.set	               D_POP_WORD_CMD | D_PUSH_WORD_CMD 
	
	.endif	;__icss_miirt_regs_h
