;******************************************************************************
;+--------------------------------------------------------------------------+**
;|                            ****                                          |**
;|                            ****                                          |**
;|                            ******o***                                    |**
;|                      ********_;/_****                                   |**
;|                      ***** /_;_/ ****                                   |**
;|                       ** ** (__/ ****                                    |**
;|                           *********                                      |**
;|                            ****                                          |**
;|                            ***                                           |**
;|                                                                          |**
;|         Copyright (c) 1998-2012 Texas Instruments Incorporated           |**
;|                        ALL RIGHTS RESERVED                               |**
;|                                                                          |**
;| Permission is hereby granted to licensees of Texas Instruments           |**
;| Incorporated (TI) products to use this computer program for the sole     |**
;| purpose of implementing a licensee product based on TI products.         |**
;| No other rights to reproduce, use, or disseminate this computer          |**
;| program, whether in part or in whole, are granted.                       |**
;|                                                                          |**
;| TI makes no representation or warranties with respect to the             |**
;| performance of this computer program, and specifically disclaims         |**
;| any responsibility for any damages, special or consequential,            |**
;| connected with the use of this program.                                  |**
;|                                                                          |**
;+--------------------------------------------------------------------------+**
;*****************************************************************************/
; file:   micro_scheduler.p
;
; brief:  Round-robin based micro_scheduler which controls program flow.
;
;
;  (C) Copyright 2012, Texas Instruments, Inc
;
;	Version		Description					Author
;
; 	0.1	        Created						Robin Singh
;	0.2		Updated for Common Baseline			Anjandeep Sahni
;	0.3		Added TTS Support				Anjandeep Sahni
	
;;///////////////////////////////////////////////////////
; Includes Section
;;///////////////////////////////////////////////////////
	.include "firmware_version.h"
	.include "micro_scheduler.h"
	.include "icss_emacSwitch.h"
	.include "emac_MII_Rcv.h"
	.include "emac_MII_Xmt.h"
	.include "icss_defines.h"
	.include "icss_miirt_regs.h"
	.include "icss_iep_regs.h"
	.include "icss_macros.h"
	.include "icss_mdio_regs.h"
	.include "emac_tts.h"
	
;.setcallreg CALL_REG
        .retain     ; Required for building .out with assembly file
        .retainrefs ; Required for building .out with assembly file

        .global  FN_RCV_FB
        .global  STATS_TASK
        .global  MII_TX_TASK
        .global  FN_RCV_NB
        .global  FN_RCV_LB
        .global  TASK_EXECUTION_FINISHED
        .global  FN_TTS_IEP_CFG_PRE_AM571x
        .global  FN_TTS_IEP_CFG_CLEAR
        .global  RET_TTS_IEP_CFG_CLEAR
        .global  RET_TTS_IEP_CFG_PRE
        .global  FN_TTS_IEP_CMPCFG_ARBITRATION
        .global  FN_TTS_IEP_CFG_PRE_AM335x
        .global  FN_TTS_EXIT_IEP_CMPCFG_ARBITRATION
        .sect    ".text:micro_scheduler"
        .global  micro_scheduler
;	.origin 0
;	.entrypoint firm_main
	
micro_scheduler:
	JMP		fw_main
	
	;	Firmware Version: To identify using firmware header files.
	.word   ICSS_FIRMWARE_RELEASE_1
	.word   ICSS_FIRMWARE_RELEASE_2
	
fw_main:
	;	Firmware Version: To store in shared memory. Can be used by application.

	; USER***MANUAL Line with possibly different expansions with different options
	.if !$isdefed("__firmware_version_h")
	.if $isdefed("SOC_AM335x")
	LDI	R0 , ((FIRMWARE_DEVICE_AM335x << 8) | (0x11 << 0))
	.endif
	.if $isdefed("SOC_AM571x")
	LDI	R0 , ((FIRMWARE_DEVICE_AM571x << 8) | (0x11 << 0))
	.endif
	.endif
	; USER***MANUAL Line with different expansions ended

	LDI	R1.w0 , ICSS_EMAC_FIRMWARE_RELEASE_1_OFFSET
	SBCO	&R0, ICSS_SHARED_CONST, R1.w0, 4	

	; USER***MANUAL Line with possibly different expansions with different options
	.if !$isdefed("__firmware_version_h")
	.if $isdefed("DEBUG")
	LDI	R0 , ((0 << 31) | (FIRMWARE_VERSION_MAJOR << 24) | (FIRMWARE_VERSION_MINOR << 16) | (FIRMWARE_VERSION_BUILD << 0))
	.else
	LDI	R0 , ((1 << 31) | (FIRMWARE_VERSION_MAJOR << 24) | (FIRMWARE_VERSION_MINOR << 16) | (FIRMWARE_VERSION_BUILD << 0))
	.endif
	.endif
	; USER***MANUAL Line with different expansions ended

	LDI	R1.w0 , ICSS_EMAC_FIRMWARE_RELEASE_2_OFFSET
	SBCO	&R0, ICSS_SHARED_CONST, R1.w0, 4	
	
	ZERO	&R0, 124		;Zero all registers
	LDI	R31 , 0
	M_SET_CMD	D_RESET_RXFIFO | D_RESET_TXFIFO		; reset RX and TX FIFO
	; Packet TX Allowed
	SET	R22 , R22 , 31 
	.if $isdefed("PRU_DEBUG_EDIO")	
	LDI EDIO_OFFSET, 0x310  ; HW debug pins - specific offset to register
	EDIO_OUT0_CLR
	.endif
	
	;Configure the Task Table
	LDI	TASK_TABLE_ROW0.w0, 0x0100	
	LDI	TASK_TABLE_ROW0.w2, 0x0002	
	
START_THE_MS:
	
	.if $isdefed("TTS")	
	.if $isdefed("SOC_AM335x")	
	;Set IEP wraparound to 1s. This will be standard for 32-bit IEP in EMAC.
	M_TTS_SET_CMP0_IEP_WRAP
	.endif	;SOC_AM335x
	.endif	;TTS
	
	; Load Address of R19 Register
	LDI	CURRENT_TASK_POINTER, RX_TASK_POINTER	
	
	; Loop over the Task's List
LOOP_OVER_TASKS:
	
	;Check if time triggered send is enabled.
	.if $isdefed("TTS")	
	M_CHECK_TTS_ENABLE
RET_TTS_IEP_CFG_CLEAR:
	.endif	;TTS
	
	; check for RX EOF condition
	.if $isdefed("SOC_AM335x")	
	M_MS_RX_EOF_CHECK_AM335x
	.endif
	.if $isdefed("SOC_AM571x")	
	M_MS_RX_EOF_CHECK_AM571x
	.endif
	
	; Call the RCV_LB which resets the Rx L2 Fifo
	JAL	CALL_REG, FN_RCV_LB	
	
	;Check for SFD event
check_sfd:
	XIN	RX_L2_BANK0_ID, &R2, (4 * 17)	; Bank 0, R2 - R18		
	
	QBBC	EXECUTE_NEXT_TASK, R10, 5	 ;replaced: QBBC   	EXECUTE_NEXT_TASK, R10.b0.RXL2_RX_SOF_BIT 
	QBGT	SKIP_RCV_TASK, R18_RCV_BYTECOUNT, 18	
	JAL	CALL_REG, FN_RCV_FB	
SKIP_RCV_TASK:
	QBNE	EXECUTE_NEXT_TASK, CURRENT_TASK_POINTER, RX_TASK_POINTER	
	ADD	CURRENT_TASK_POINTER, CURRENT_TASK_POINTER, 1	
	
Check_RCV_Active:
	QBBS	EXECUTE_NEXT_TASK, R23, 1	 ;replaced: QBBS    EXECUTE_NEXT_TASK, Rcv_active 
	QBA     check_sfd
	
EXECUTE_NEXT_TASK:
	MVIB	TEMP_REG_3.b0, *CURRENT_TASK_POINTER	
	QBEQ	TASK_LIST_WRAPS, CURRENT_TASK_POINTER, BG_TASK_POINTER	
	ADD	CURRENT_TASK_POINTER, CURRENT_TASK_POINTER, 1	
	JMP	NO_TASK_LIST_WRAP
	
TASK_LIST_WRAPS:
	LDI	CURRENT_TASK_POINTER, RX_TASK_POINTER	
	
NO_TASK_LIST_WRAP:
	QBEQ	MII_RX_Task, TEMP_REG_3.b0, 0x00	
	QBEQ	MII_TX_Task_inter, TEMP_REG_3.b0, 0x01	
	QBEQ	BACKGROUND_TASK, TEMP_REG_3.b0, 0x02	
	
;This should never happen
ERROR:
	HALT
	
TASK_EXECUTION_FINISHED:
	.if $isdefed("TTS")	
	.if $isdefed("SOC_AM335x")	
	M_TTS_CMP0_CMP7_CHECK
	.endif
	M_TTS_CMP3_CMP4_CHECK
	.endif	;TTS
	
	QBBS	LOOP_OVER_TASKS, R22, 31	 ;replaced: QBBS	LOOP_OVER_TASKS, PACKET_TX_ALLOWED 
	
	.if $isdefed("SOC_AM335x")	
	M_MS_TEF_AM335x
	.endif
	.if $isdefed("SOC_AM571x")	
	M_MS_TEF_AM571x
	.endif
	
	.if $isdefed("TTS")	
	;TX_ENABLE bit is auto cleared in TX_EN_MODE.
	;Need to set TX_ENABLE bit if TTS is enabled.
	M_SET_MIIRT_TXCFG_TX_ENABLE
	.endif	;TTS
	
	SET	R22 , R22 , 31 
	JMP	LOOP_OVER_TASKS
	
	
;;///////// Receive Task ////////////////////////		
MII_RX_Task:
	
	.if $isdefed("PRU_MEAS_RXTASK")	
	EDIO_OUT0_SET
	.endif
	JMP		FN_RCV_NB
	
;;/////////   Transmit Task	/////////////////	
MII_TX_Task_inter:
	
	.if $isdefed("PRU_MEAS_TXTASK")	
	EDIO_OUT0_SET
	.endif
	QBBC	TASK_EXECUTION_FINISHED, R22, 31	 ;replaced: QBBC	TASK_EXECUTION_FINISHED, PACKET_TX_ALLOWED 
	
	.if $isdefed("TTS")	
	;Need to check essential conditions before TTS configuration.
	M_TTS_CFG_CONDITIONAL_CONSTRUCT
RET_TTS_IEP_CFG_PRE:
	.endif	;TTS
	
	JAL	CALL_REG, MII_TX_TASK	
	JMP	TASK_EXECUTION_FINISHED
	
;;////////   Stats Task
BACKGROUND_TASK:
	QBBS	stat_task_called, R23, 2	 ;replaced: QBBS	stat_task_called, TX_STAT_PEND 
	QBBC	coll_task_called, R23, 3	 ;replaced: QBBC	coll_task_called, RX_STAT_PEND 
stat_task_called:
	JAL	CALL_REG, STATS_TASK	
coll_task_called:
	JMP	TASK_EXECUTION_FINISHED

