;******************************************************************************
;+--------------------------------------------------------------------------+**
;|                            ****                                          |**
;|                            ****                                          |**
;|                            ******o***                                    |**
;|                      ********_;/_****                                   |**
;|                      ***** /_;_/ ****                                   |**
;|                       ** ** (__/ ****                                    |**
;|                           *********                                      |**
;|                            ****                                          |**
;|                            ***                                           |**
;|                                                                          |**
;|         Copyright (c) 1998-2010 Texas Instruments Incorporated           |**
;|                        ALL RIGHTS RESERVED                               |**
;|                                                                          |**
;| Permission is hereby granted to licensees of Texas Instruments           |**
;| Incorporated (TI) products to use this computer program for the sole     |**
;| purpose of implementing a licensee product based on TI products.         |**
;| No other rights to reproduce, use, or disseminate this computer          |**
;| program, whether in part or in whole, are granted.                       |**
;|                                                                          |**
;| TI makes no representation or warranties with respect to the             |**
;| performance of this computer program, and specifically disclaims         |**
;| any responsibility for any damages, special or consequential,            |**
;| connected with the use of this program.                                  |**
;|                                                                          |**
;+--------------------------------------------------------------------------+**
;*****************************************************************************/
; file:   micro_scheduler.hp
;
; brief:  ICSS defines and macros used by Micro_Scheduler
;
;
;  (C) Copyright 2010, Texas Instruments, Inc
;
;	Version		Description								Author
;
; 	0.1     	Created									?
;	0.2			Updated for Common Baseline				Anjandeep Sahni
;	0.3			Added TTS Support						Anjandeep Sahni
	
	.if !$isdefed("__ICSS_MICRO_SCHEDULER_H__")	
__ICSS_MICRO_SCHEDULER_H__	.set	1 
	
	.include "icss_emacSwitch.h"
	.include "icss_defines.h"
	
	.asg	R0, TEMP_REG_1	
	.asg	R4, TEMP_REG_2	
	.asg	R2, TEMP_REG_3	
	.asg	R3, TEMP_REG_4	
	
MS_OVERHEAD	.set	0x17	
	.asg	R19, TASK_TABLE_ROW0	
	
;R22 bit usage. This is reserved usage, cannot be used for other purposes
	.asg	R22.t31, PACKET_TX_ALLOWED	
	.asg	R22.t30, Entire_Tx_Data_Not_Pushed	
	.asg	R22.t29, RX_LB_PARTIALLY_PROCESSED	
	.asg	R22.t28, RX_BC_FRAME	
	.asg	R22.t27, RX_MC_FRAME	
	.asg	R22.t26, TX_BC_FRAME	
	.asg	R22.t25, TX_MC_FRAME	
	.asg	R22.t24, RX_FWD_FLAG	
	
	.if $isdefed("HALF_DUPLEX_ENABLED")	
	.asg	R22.t23, PORT_IS_HALF_DUPLEX	
	.asg	R22.t22, TX_LATE_COLLISION	
	.endif
	
	.if $isdefed("TTS")	
	.asg	R22.t21, TTS_ENABLE	
	.asg	R22.t20, TTS_FIRST_SETUP	
	.asg	R22.t19, TTS_RT_QUEUE_PKT	
	.asg	R22.t18, TTS_FIRST_PKT_done	
	.asg	R22.t17, TTS_FIRST_PKT_since_enable	
	.asg	R22.t16, TTS_CMP_3456_FIRST_Exception	
	.asg	R22.t15, TTS_CMP5_CMP6_in_next_IEP_cycle	
	.endif	;TTS
	
RX_TASK_POINTER	.set	0x4c	
TX_TASK_POINTER	.set	0x4d	
BG_TASK_POINTER	.set	0x4e	
	
ECAP_BASE_ADDR	.set	0x00030000	
ICSS_RAM_BASE	.set	0x00010000	
	
PERIOD_COUNT_OFFSET	.set	0x0	
RX_COUNT_OFFSET	.set	0x4	
TX_COUNT_OFFSET	.set	0x8	
BRIDGE_COUNT_OFFSET	.set	0xc	
STAT_COUNT_OFFSET	.set	0x10	
HOST_COUNT_OFFSET	.set	0x14	
	
ECAP_CNT	.set	0x00	
ECAP_CMP1	.set	0x08	
ECAP_ECCTL2	.set	0x2a	
ECAP_ECEINT	.set	0x2c	
ECAP_ECFLG	.set	0x2e	
ECAP_ECCLR	.set	0x30	
RX_FB_THRESHOLD	.set	0x0E	
THRESHOLD_TASKS_SCAN	.set	0x1E	
	
INTC_BASE	.set	0x00020000	
	
	.asg	R1.b2, CURRENT_TASK_POINTER	
	
PRU_CONTROL_REG	.set	0x00	
PRU_CYCLE_COUNT_REG	.set	0x0c	
PRU_CONTROL_REGS	.set	0x00022000	
	
IEP_GLOBAL_CFG_REG	.set	0x00	
IEP_COMPEN_REG	.set	0x08	
	
	.if $isdefed("SOC_AM335x")	
IEP_COUNTER_OFFSET	.set	0x0c	
CAP_RISE_RX_SOF_PORT1_OFFSET	.set	0x18	
CAP_RISE_RX_SFD_PORT1_OFFSET	.set	0x1c	
CAP_RISE_RX_SOF_PORT2_OFFSET	.set	0x20	
CAP_RISE_RX_SFD_PORT2_OFFSET	.set	0x24	
CAP_RISE_TX_SOF_PORT1_OFFSET	.set	0x28	
CAP_RISE_TX_SOF_PORT2_OFFSET	.set	0x2c	
IEP_CMP_CFG_REG	.set	0x40	
IEP_CMP_STATUS_REG	.set	0x44	
IEP_CMP0_REG	.set	0x48	
IEP_CMP1_REG	.set	0x4c	
IEP_CMP2_REG	.set	0x50	
IEP_CMP6_REG	.set	0x60	
IEP_CMP7_REG	.set	0x64	
	
IEP_SYNC_CTRL_REG	.set	0x100	
IEP_SYNC_PWIDTH_REG	.set	0x110	
	.endif	;SOC_AM335x
	
	.if $isdefed("SOC_AM571x")	
IEP_COUNTER_OFFSET	.set	0x10	
CAP_RISE_RX_SOF_PORT1_OFFSET	.set	0x20	
CAP_RISE_RX_SFD_PORT1_OFFSET	.set	0x28	
CAP_RISE_RX_SOF_PORT2_OFFSET	.set	0x30	
CAP_RISE_RX_SFD_PORT2_OFFSET	.set	0x38	
CAP_RISE_TX_SOF_PORT1_OFFSET	.set	0x40	
CAP_RISE_TX_SOF_PORT2_OFFSET	.set	0x48	
IEP_CMP_CFG_REG	.set	0x70	
IEP_CMP_STATUS_REG	.set	0x74	
IEP_CMP0_REG	.set	0x78	
IEP_CMP1_REG	.set	0x80	
IEP_CMP2_REG	.set	0x88	
IEP_CMP6_REG	.set	0xa8	
IEP_CMP7_REG	.set	0xb0	
	.endif	;SOC_AM571x
	
;-----------------------------------
; Macro Name: M_MS_TEF_AM335x
; Description: Set of instructions to execute when Task Execution is Finished (TEF) for AM335x.
; Input Parameters: none
; Output Parameters: none
;-----------------------------------
M_MS_TEF_AM335x	 .macro
	;Check whether T(EOF) has come
	LDI	TEMP_REG_1.w0, 0x0204	
	LBCO	&TEMP_REG_2, ICSS_INTC_CONST, TEMP_REG_1.w0, 4	
	.if $isdefed("PRU0")	
	QBBC	LOOP_OVER_TASKS, TEMP_REG_2, 7	 ;replaced: QBBC	LOOP_OVER_TASKS, TEMP_REG_2.t7 
	.else
	QBBC	LOOP_OVER_TASKS, TEMP_REG_2, 19	 ;replaced: QBBC	LOOP_OVER_TASKS, TEMP_REG_2.t19 
	.endif
	
	M_TX_RESET
	M_PUSH_TX_EOF
	;M_TX_DISABLE
	
	;Clear the Underflow error
	.if $isdefed("PRU0")	
	LDI	TEMP_REG_4.w0, 0x0284	
	LDI	TEMP_REG_3 , 0x00000080
	SBCO	&TEMP_REG_3, ICSS_INTC_CONST, TEMP_REG_4.w0, 4	
	.else
	LDI	TEMP_REG_4.w0, 0x0284	
	LDI	TEMP_REG_3.w0 , 0x00080000 & 0xFFFF
	LDI	TEMP_REG_3.w2 , 0x00080000 >> 16
	SBCO	&TEMP_REG_3, ICSS_INTC_CONST, TEMP_REG_4.w0, 4	
	.endif
	
	;Raise Tx Completion interrupt to Host
	;Two interrupts for two ports in MAC mode.
	.if $isdefed("PRU0")	
	LDI	R31, 0x26	;Maps to system event 22, 0x26 = 100110
	.else
	LDI	R31, 0x27	;Maps to system event 23, 0x27 = 100111
	.endif
	.endm
	
;-----------------------------------
; Macro Name: M_MS_TEF_AM571x
; Description: Set of instructions to execute when Task Execution is Finished (TEF) for AM571x.
; Input Parameters: none
; Output Parameters: none
;-----------------------------------
M_MS_TEF_AM571x	 .macro
	;Check whether T(EOF) has come
	QBBC	LOOP_OVER_TASKS, R31, 16	 ;replaced: QBBC	LOOP_OVER_TASKS, R31.t16 
	
	; Raise Tx Completion Interrupt to host
	;Two interrupts for two ports in MAC mode.
	.if $isdefed("PRU0")	
	LDI	R31, 0x26	; Maps to system event 22, 0x26 = 100110
	.else
	LDI	R31, 0x27	; Maps to system event 23, 0x27 = 100111
	.endif
	.endm
	
;-----------------------------------
; Macro Name: M_MS_RX_EOF_CHECK_AM335x
; Description: Check for RX EOF on AM335x.
; Input Parameters: none
; Output Parameters: none
;-----------------------------------
M_MS_RX_EOF_CHECK_AM335x	 .macro
	.if $isdefed("PRU0")	
	QBBC	Check_RCV_Active, R31, 30	 ;replaced: QBBC	Check_RCV_Active, R31.t30 ; Port0 Rx EOF
	.else
	QBBC	Check_RCV_Active, R31, 31	 ;replaced: QBBC	Check_RCV_Active, R31.t31 ; Port1 Rx EOF
	.endif
	.endm
	
;-----------------------------------
; Macro Name: M_MS_RX_EOF_CHECK_AM571x
; Description: Check for RX EOF on AM571x.
; Input Parameters: none
; Output Parameters: none
;-----------------------------------
M_MS_RX_EOF_CHECK_AM571x	 .macro
	QBBC	Check_RCV_Active, R31, 20	 ;replaced: QBBC	Check_RCV_Active, R31.t20 ; Port Rx EOF	
	.endm
	
	.endif ;__ICSS_MICRO_SCHEDULER_H__
