//
// AnalogInput_InternalThermometer_430
// Analog Input - MSP430 Internal Thermometer
//
// Demonstrates analog input by reading the internal temperature sensor.
//
// Created by Robert Wessels
// modified 7 March 2012
// By Robert Wessels
//
// This example code is in the public domain.
//
// Revision:
// Rei VILO, Mar 12, 2012 - One decimal place
// Rei VILO, Mar 13, 2012 - More precise algorithm
// Rei VILO, Mar 14, 2012 - Average
// Rei VILO, May 21, 2012 - Updated with GREEN_LED, RED_LED and PUSH2
// Rei VILO, Sep 09, 2012 - TimerSerial.h no longer required
// Rei VILO, Sep 24, 2012 - FraunchPad excluded
// Paul G.,  Feb 24, 2016 - Fix for occasionally missing commands due to Stream.flush() operation.
// Press push 2 to end
// Tested on msp430g2452 and msp430g2553
// 2196 bytes
#if defined(__MSP430G2452__) || defined(__MSP430G2553__) || defined(__MSP430G2231__)
#else
#error Board not supported
#endif
// RED_LED, GREEN_LED, TEMPSENSOR, PUSH2 already defined
#define NUMBER 1 // take number / 2
#define MAX_JSON_STRLEN 40
int greenLedState = HIGH;
int redLedState = LOW;
uint8_t i = 0;
uint32_t average = 0;
uint32_t values[NUMBER];
char jsonStrFromHost[MAX_JSON_STRLEN];
uint8_t numBytesRead = 0;
uint8_t j = 0;
uint8_t n = 0;
boolean flag = true;
boolean running = false;
int debounceCounter = 0;
void setup() {
  pinMode(RED_LED, OUTPUT);
  pinMode(GREEN_LED, OUTPUT);
  analogReference(INTERNAL1V5);
  analogRead(TEMPSENSOR); // first reading usually wrong
  Serial.setTimeout(6000); // 1s timeout when reading from serial port
  Serial.begin(9600);
  pinMode(PUSH2, INPUT_PULLUP);
  digitalWrite(RED_LED, HIGH);
  digitalWrite(GREEN_LED, LOW);

  for (j=0; j<NUMBER; j++) {
    values[j]=0;
  }
  clearJsonStr();
  Serial.flush();
  average = 0;
  j=0;
}
void printDec(uint32_t ui) {
  if (ui < 9999){
    Serial.print(ui/100, DEC);
    Serial.print(".");
    if ((ui%100) < 10){
      Serial.print("0");  
    }  
    Serial.print(ui%100, DEC);
  } 
  else {
    Serial.print("99.99");
  }
}

void clearJsonStr(){
   int i;
   for (i=0; i < MAX_JSON_STRLEN; i++){
     jsonStrFromHost[i] = (char)0;
   }  
}
int getSerialString(){
  int i=0;
  char rxChar;
  boolean done = false;
  int waitCtr = 0;
  clearJsonStr();
  while (!done){
      if (Serial.available() > 0){
         rxChar = Serial.read();
         if (rxChar != -1){
           if (rxChar == (char)10){
             done = true;

           } else if (i < MAX_JSON_STRLEN) {  
             jsonStrFromHost[i++] = rxChar;
           } else {
             Serial.flush();
             done = true;
             i = 0;
           }
         }  
      } else {
        delayMicroseconds(100);     // pauses for 0.1 milliseconds
        waitCtr++;
        if (waitCtr > 3000) {
          done = true;
        }  
      } 
  }
  return(i);
  
}  
void loop() {
  if (running){
    

       numBytesRead = getSerialString();//Serial.readBytesUntil('\n',jsonStrFromHost,MAX_JSON_STRLEN);
       if (numBytesRead > 2){
	  // Data from the host needs to be of the form {"LEDs":{"Red":0,"Green":0}} to turn off 
          // the red and green LEDs, {"LEDs":{"Red":1,"Green":1}} to turn on the red and green LEDs.
          // (Code is not generic at all, but it is small  )
             
          for (j=2; j < numBytesRead; j++){
            if ((jsonStrFromHost[j] == ':') && (j < (numBytesRead + 1))){
              if (jsonStrFromHost[j-2] == 'd'){
                 if (jsonStrFromHost[j+1] == '1'){
                   redLedState = HIGH;
                 }  else {
                   redLedState = LOW;
                 }
                 digitalWrite(RED_LED, redLedState);
                 flag=true;
              } else {
                 if (jsonStrFromHost[j-2] == 'n'){
                   if (jsonStrFromHost[j+1] == '1'){
                      greenLedState = HIGH;
                   }  else {
                      greenLedState = LOW;
                   }
                   digitalWrite(GREEN_LED, greenLedState);
                   flag=true;
                 }
              }
            } 
          }
          
       }
    

    // Formula: http://www.43oh.com/forum/viewtopic.php?p=18248#p18248
    average -= values[n];
    // In Degrees Celsius:
    //values[j] = ((uint32_t)analogRead(TEMPSENSOR)*27069 - 18169625) *100 >> 16;
    // In Farenheit:
    values[n] = ((uint32_t)analogRead(TEMPSENSOR)*48724 - 30634388) *100 >> 16;
    average += values[n];
    // Print average as a JSON string of the form {"temp":99.99,"LED":0}
    if (flag) {
     Serial.print("{\"temp\":");
      printDec(average/NUMBER);
      Serial.print(",\"LEDs\":{\"Red\":");
      Serial.print(redLedState, DEC);
      Serial.print(",\"Green\":");
      Serial.print(greenLedState, DEC);
      Serial.print("}}\n");
      //flag = false;

    } 
    n++;
    if (n==NUMBER) {
      flag=true;
      n = 0;
    } 
  } 
  if (digitalRead(PUSH2)==LOW) {
    if (debounceCounter == 2){
      running = !running;
      if (running) {
        greenLedState = HIGH;
        redLedState = LOW;
      } else {
        greenLedState = LOW;
        redLedState = LOW;
      }   
      digitalWrite(GREEN_LED, greenLedState);
      digitalWrite(RED_LED, redLedState);
      debounceCounter = 9;
    } else {
      debounceCounter++;
    }
  } else {
    debounceCounter = 0;
  }
  delay(40);

}



