#
#  ======== ndk.mak ========
#

#
# Where to install/stage the packages
# Typically this would point to the devkit location
#
DESTDIR ?= 

prefix ?= /
docdir ?= /docs/ndk
packagesdir ?= /packages

# USER STEP: user must define below path to xdc installation
# Set up dependencies
XDC_INSTALL_DIR ?= C:\ti\xdctools_3_51_01_18_core
SYSBIOS_INSTALL_DIR ?= C:\ti\bios_6_75_02_00
NS_INSTALL_DIR ?= C:\ti\ns_2_60_00_07

# Optional: Set this to enable MBEDTLS-enabled SlNetIf libraries
# (not all devices support this yet)
MBEDTLS_INSTALL_DIR ?=

#
# Set location of various cgtools
# These variables can be set here or on the command line.
#
# USER STEP: user must define below paths to compilers
ti.targets.elf.C66 ?=
ti.targets.elf.C66_big_endian ?=
ti.targets.elf.C674 ?=

ti.targets.arm.elf.Arm9 ?=
ti.targets.arm.elf.A8F ?=
ti.targets.arm.elf.A8Fnv ?=
ti.targets.arm.elf.M3 ?=
ti.targets.arm.elf.M4 ?=
ti.targets.arm.elf.M4F ?=
ti.targets.arm.elf.R5F ?=

gnu.targets.arm.M3 ?=
gnu.targets.arm.M4 ?=
gnu.targets.arm.M4F ?=
gnu.targets.arm.A8F ?=
gnu.targets.arm.A9F ?=
gnu.targets.arm.A15F ?=C:\ti\ccs920\ccs\tools\compiler\gcc-arm-none-eabi-7-2017-q4-major-win32

iar.targets.arm.M3 ?=
iar.targets.arm.M4F ?=
iar.targets.arm.M4 ?=

# Set BUILDMINSTACK to 1 to only build base stack libraries (stk.a* and stk6.a*)
BUILDMINSTACK ?= 0

# Derive POSIX location from SYSBIOS
TIPOSIX_REPO ?= $(SYSBIOS_INSTALL_DIR)/packages

#
# Set XDCARGS to some of the variables above.  XDCARGS are passed
# to the XDC build engine... which will load ndk.bld... which will
# extract these variables and use them to determine what to build and which
# toolchains to use.
#
# Note that not all of these variables need to be set to something valid.
# Unfortunately, since these vars are unconditionally assigned, your build line
# will be longer and more noisy than necessary
#
# Some background is here:
#     http://rtsc.eclipse.org/docs-tip/Command_-_xdc#Environment_Variables
#
XDCARGS= \
    ti.targets.arm.elf.Arm9=\"$(ti.targets.arm.elf.Arm9)\" \
    ti.targets.arm.elf.A8F=\"$(ti.targets.arm.elf.A8F)\" \
    ti.targets.arm.elf.A8Fnv=\"$(ti.targets.arm.elf.A8Fnv)\" \
    ti.targets.arm.elf.M3=\"$(ti.targets.arm.elf.M3)\" \
    ti.targets.arm.elf.M4=\"$(ti.targets.arm.elf.M4)\" \
    ti.targets.arm.elf.M4F=\"$(ti.targets.arm.elf.M4F)\" \
    ti.targets.arm.elf.R5F=\"$(ti.targets.arm.elf.R5F)\" \
    ti.targets.elf.C66=\"$(ti.targets.elf.C66)\" \
    ti.targets.elf.C66_big_endian=\"$(ti.targets.elf.C66_big_endian)\" \
    ti.targets.elf.C674=\"$(ti.targets.elf.C674)\" \
    gnu.targets.arm.M3=\"$(gnu.targets.arm.M3)\" \
    gnu.targets.arm.M4=\"$(gnu.targets.arm.M4)\" \
    gnu.targets.arm.M4F=\"$(gnu.targets.arm.M4F)\" \
    gnu.targets.arm.A8F=\"$(gnu.targets.arm.A8F)\" \
    gnu.targets.arm.A9F=\"$(gnu.targets.arm.A9F)\" \
    gnu.targets.arm.A15F=\"$(gnu.targets.arm.A15F)\" \
    iar.targets.arm.M3=\"$(iar.targets.arm.M3)\" \
    iar.targets.arm.M4F=\"$(iar.targets.arm.M4F)\" \
    iar.targets.arm.M4=\"$(iar.targets.arm.M4)\" \
    BUILDMINSTACK=\"$(BUILDMINSTACK)\" \
    TIPOSIX_REPO=\"$(TIPOSIX_REPO)\" \
    MBEDTLS_INSTALL_DIR=$(MBEDTLS_INSTALL_DIR) \
    NS_INSTALL_DIR=\"$(NS_INSTALL_DIR)\"

#
# Set XDCPATH to contain necessary repositories.
#
XDCPATH = $(SYSBIOS_INSTALL_DIR)/packages;
export XDCPATH

#
# Set XDCOPTIONS.  Use -v for a verbose build.
#
#XDCOPTIONS=v
export XDCOPTIONS

j = 8
#
# Set XDC executable command
# Note that XDCBUILDCFG points to the ndk.bld file which uses
# the arguments specified by XDCARGS
#
XDC = $(XDC_INSTALL_DIR)/xdc -j $(j) XDCARGS="$(XDCARGS)" XDCBUILDCFG=./ndk.bld

######################################################
## Shouldnt have to modify anything below this line ##
######################################################

all:
	@ echo building ndk packages ...
	@ $(XDC) -Pr ./packages

clean:
	@ echo cleaning ndk packages ...
	@ $(XDC) clean -Pr ./packages

install-packages:
	@ echo installing ndk packages to $(DESTDIR) ...
	@ mkdir -p $(DESTDIR)/$(prefix)/$(docdir)
	@ cp -rf $(wildcard ndk_*_ReleaseNotes.html) docs/* $(DESTDIR)/$(prefix)/$(docdir)
	@ mkdir -p $(DESTDIR)/$(prefix)/$(packagesdir)
	@ cp -rf packages/* $(DESTDIR)/$(prefix)/$(packagesdir)
