
#define ROM_BASE 0x00001000
#define RAM_BASE 0x20000000

MEMORY
{
    /* ROM code */
    ROM (RX) : origin = ROM_BASE, length = 0x00000800
    /* Application uses internal RAM for data */
    SRAM (RWX) : origin = 0x20000000, length = 0x00000200
    /* Application can be stored in DRAM and executes from DRAM */
    DRAM (RX) : origin = 0x21000000, length = 0x00000400
}

/* Section allocation in memory */

SECTIONS
{
    .romapitable: > ROM_BASE
    .lib    :   > ROM ,palign = 4
    .text   :   > ROM ,palign = 4
    .const  :   > ROM ,palign = 4
    .cinit  :   > ROM
    .pinit  :   > ROM
    .init_array : > ROM
    .firmwareidadd : > 0x000017F8
    .romchecksumadd : > 0x000017FC
    .vtable :   > RAM_BASE
    .data   :   > DRAM
    .bss    :   > DRAM
    .sysmem :   > DRAM
    .stack  :   > 0x20000000
}

__STACK_TOP = 0x20000000;
__OTP_MAIN = 0x00000001;
