
MEMORY
{
PAGE 0 :
   /* BEGIN is used for the "boot to Flash" bootloader mode   */

   BEGIN           	: origin = 0x00080000, length = 0x000008
   RAMM0           	: origin = 0x000000F5, length = 0x00030B

   RAMLS0          	: origin = 0x00008000, length = 0x000800
   RAMLS1          	: origin = 0x00008800, length = 0x000800
   RAMLS2      		: origin = 0x00009000, length = 0x000800
   RAMLS3      		: origin = 0x00009800, length = 0x000800
   RAMLS4      		: origin = 0x0000A000, length = 0x000800
   RESET           	: origin = 0x003FFFC0, length = 0x000002

   /* Flash sectors */
   /* BANK 0 */
   F_BANK0_SEC0_15   : origin = 0x00080008, length = 0x00FFF8
/*
   FLASH_BANK0_SEC0  : origin = 0x00080008, length = 0x000FF8
   FLASH_BANK0_SEC1  : origin = 0x00081000, length = 0x001000
   FLASH_BANK0_SEC2  : origin = 0x00082000, length = 0x001000
   FLASH_BANK0_SEC3  : origin = 0x00083000, length = 0x001000
   FLASH_BANK0_SEC4  : origin = 0x00084000, length = 0x001000
   FLASH_BANK0_SEC5  : origin = 0x00085000, length = 0x001000
   FLASH_BANK0_SEC6  : origin = 0x00086000, length = 0x001000
   FLASH_BANK0_SEC7  : origin = 0x00087000, length = 0x001000
   FLASH_BANK0_SEC8  : origin = 0x00088000, length = 0x001000
   FLASH_BANK0_SEC9  : origin = 0x00089000, length = 0x001000
   FLASH_BANK0_SEC10 : origin = 0x0008A000, length = 0x001000
   FLASH_BANK0_SEC11 : origin = 0x0008B000, length = 0x001000
   FLASH_BANK0_SEC12 : origin = 0x0008C000, length = 0x001000
   FLASH_BANK0_SEC13 : origin = 0x0008D000, length = 0x001000
   FLASH_BANK0_SEC14 : origin = 0x0008E000, length = 0x001000
   FLASH_BANK0_SEC15 : origin = 0x0008F000, length = 0x001000
*/

   /* BANK 1 */
   F_BANK1_SEC0_15   : origin = 0x00090000, length = 0x010000
/*
   FLASH_BANK1_SEC0  : origin = 0x00090000, length = 0x001000
   FLASH_BANK1_SEC1  : origin = 0x00091000, length = 0x001000
   FLASH_BANK1_SEC2  : origin = 0x00092000, length = 0x001000
   FLASH_BANK1_SEC3  : origin = 0x00093000, length = 0x001000
   FLASH_BANK1_SEC4  : origin = 0x00094000, length = 0x001000
   FLASH_BANK1_SEC5  : origin = 0x00095000, length = 0x001000
   FLASH_BANK1_SEC6  : origin = 0x00096000, length = 0x001000
   FLASH_BANK1_SEC7  : origin = 0x00097000, length = 0x001000
   FLASH_BANK1_SEC8  : origin = 0x00098000, length = 0x001000
   FLASH_BANK1_SEC9  : origin = 0x00099000, length = 0x001000
   FLASH_BANK1_SEC10 : origin = 0x0009A000, length = 0x001000
   FLASH_BANK1_SEC11 : origin = 0x0009B000, length = 0x001000
   FLASH_BANK1_SEC12 : origin = 0x0009C000, length = 0x001000
   FLASH_BANK1_SEC13 : origin = 0x0009D000, length = 0x001000
   FLASH_BANK1_SEC14 : origin = 0x0009E000, length = 0x001000
   FLASH_BANK1_SEC15 : origin = 0x0009F000, length = 0x001000
*/

   BEGIN_ECC            : origin = 0x01080000, length = 0x000001, ECC = { input_range = BEGIN,           input_page = 0, algorithm = eccalgo, fill = true }
   F_BANK0_SEC0_15_ECC  : origin = 0x01080001, length = 0x001FFF, ECC = { input_range = F_BANK0_SEC0_15, input_page = 0, algorithm = eccalgo, fill = true }
   F_BANK1_SEC0_15_ECC  : origin = 0x01082000, length = 0x002000, ECC = { input_range = F_BANK1_SEC0_15, input_page = 0, algorithm = eccalgo, fill = true }

PAGE 1 :

   BOOT_RSVD       : origin = 0x000002, length = 0x0000F3     /* Part of M0, BOOT rom will use this for stack */
   RAMM1           : origin = 0x000400, length = 0x000400     /* on-chip RAM block M1 */

   RAMLS5      : origin = 0x00A800, length = 0x000800
   RAMLS6      : origin = 0x00B000, length = 0x000800
   RAMLS7      : origin = 0x00B800, length = 0x000800

   RAMGS0      : origin = 0x00C000, length = 0x002000
   RAMGS1      : origin = 0x00E000, length = 0x002000
   RAMGS2      : origin = 0x010000, length = 0x002000
   RAMGS3      : origin = 0x012000, length = 0x002000
}

ECC { eccalgo : parity_mask = 0xfc
			    mirroring   = F021 }


SECTIONS
{
   codestart        : > BEGIN,     PAGE = 0, ALIGN(4)
   .text            : >>F_BANK0_SEC0_15, PAGE = 0, ALIGN(4)
   .cinit           : > F_BANK0_SEC0_15, PAGE = 0, ALIGN(4)
   .pinit           : > F_BANK0_SEC0_15, PAGE = 0, ALIGN(4)
   .switch          : > F_BANK0_SEC0_15, PAGE = 0, ALIGN(4)
   .reset           : > RESET,     PAGE = 0, TYPE = DSECT /* not used, */

   .stack           : > RAMM1,     PAGE = 1
   .ebss            : > RAMLS5,    PAGE = 1
   .esysmem         : > RAMLS5,    PAGE = 1   
   .econst          : > F_BANK0_SEC0_15, PAGE = 0, ALIGN(4)

   ramgs0           : > RAMGS0,    PAGE = 1
   ramgs1           : > RAMGS1,    PAGE = 1

    .TI.ramfunc : {} LOAD = F_BANK0_SEC0_15,
                         RUN = RAMLS0 | RAMLS1 | RAMLS2 |RAMLS3,
                         LOAD_START(_RamfuncsLoadStart),
                         LOAD_SIZE(_RamfuncsLoadSize),
                         LOAD_END(_RamfuncsLoadEnd),
                         RUN_START(_RamfuncsRunStart),
                         RUN_SIZE(_RamfuncsRunSize),
                         RUN_END(_RamfuncsRunEnd),
                         PAGE = 0, ALIGN(4)

}

/*
//===========================================================================
// End of file.
//===========================================================================
*/
