
MEMORY
{
PAGE 0 :
   // BEGIN is used for the "boot to SARAM" bootloader mode

   BEGIN           	: origin = 0x000000, length = 0x000002
   RAMM0           	: origin = 0x000122, length = 0x0002DE
   RAMD0           	: origin = 0x00B000, length = 0x000800
   RAMLS05         	: origin = 0x008000, length = 0x003000
   RESET           	: origin = 0x3FFFC0, length = 0x000002
   RAMGS0310      	: origin = 0x00F000, length = 0x008000

PAGE 1 :

   BOOT_RSVD        : origin = 0x000002, length = 0x000120     // Part of M0, BOOT rom will use this for stack
   RAMM1            : origin = 0x000400, length = 0x000400     // on-chip RAM block M1
   RAMD1            : origin = 0x00B800, length = 0x000800

   RAMGS0           : origin = 0x00C000, length = 0x001000
   RAMGS1           : origin = 0x00D000, length = 0x001000
   RAMGS2           : origin = 0x00E000, length = 0x001000

   RAMGS1315        : origin = 0x019000, length = 0x003000
   
   EMIF1_CS0n       : origin = 0x80000000, length = 0x10000000
   EMIF1_CS2n       : origin = 0x00100000, length = 0x00200000
   EMIF1_CS3n       : origin = 0x00300000, length = 0x00080000
   EMIF1_CS4n       : origin = 0x00380000, length = 0x00060000
   EMIF2_CS0n       : origin = 0x90000000, length = 0x10000000
   EMIF2_CS2n       : origin = 0x00002000, length = 0x00001000 

   CPU2TOCPU1RAM    : origin = 0x03F800, length = 0x000400
   CPU1TOCPU2RAM    : origin = 0x03FC00, length = 0x000400
}


SECTIONS
{
   codestart        : > BEGIN,     PAGE = 0
   ramfuncs         : > RAMM0      PAGE = 0
   .text            : >>RAMD0 |  RAMLS05 | RAMGS0310,   PAGE = 0
   .cinit           : > RAMM0,     PAGE = 0
   .pinit           : > RAMM0,     PAGE = 0
   .switch          : > RAMM0,     PAGE = 0
   .reset           : > RESET,     PAGE = 0, TYPE = DSECT // not used

   .cio             : > RAMGS1315, PAGE = 1
   .stack           : > RAMD1,     PAGE = 1
   .ebss            : > RAMGS1315, PAGE = 1
   .econst          : > RAMGS1315, PAGE = 1
   .esysmem         : > RAMGS1315, PAGE = 1
   
   .farbss          : > EMIF1_CS2n, PAGE = 1
   .farconst        : > EMIF1_CS2n, PAGE = 1
   
   ramgs0           : > RAMGS0,    PAGE = 1
   ramgs1           : > RAMGS1,    PAGE = 1

}

/*
//===========================================================================
// End of file.
//===========================================================================
*/
