/*
 * application.h
 *
 *  Created on: 06.07.2016
 *      Author: richterr
 */

#ifndef __application_h__
#define __application_h__

#include "compiler.h"
#include "F2837xD_device.h"

//*****************************************************************************
//! Set system clock rate
//*****************************************************************************
#define CPU_FRQ_200MHZ	1	//!< Use 200MHz as system clock frequency
#define CPU_FRQ_170MHZ	0
#define CPU_FRQ_150MHZ	0

//*****************************************************************************
//! Set Low Speed Clock Source Prescaler
//! See "TMS320F2837xD Dual-Core Delfino Microcontrollers - Technical Reference Manual (spruhm8); Chapters 2.14.10.16, 2.7.3.4 and Figure 2-5 in chapter 2.7".
//*****************************************************************************
#define LSP_CLK_DIV		2	//!< LSPCLK = SYSCLK / 2

//---------------------------------------------------------------------------
// Constant Definitions
// Settings for PWM Signal triggering the ADC
//---------------------------------------------------------------------------
#ifdef CPU_FRQ_190MHZ
 #define CORE_FREQ		190000   	// DSP FREQ [kHz]
 #define SYSCLK			190000000	// System clock [Hz]
#elif CPU_FRQ_180MHZ
 #define CORE_FREQ		180000
 #define SYSCLK			180000000
#elif CPU_FRQ_170MHZ
 #define CORE_FREQ		170000
 #define SYSCLK			170000000
#elif CPU_FRQ_160MHZ
 #define CORE_FREQ		160000
 #define SYSCLK			160000000
#elif CPU_FRQ_150MHZ
 #define CORE_FREQ		150000
 #define SYSCLK			150000000
#elif CPU_FRQ_140MHZ
 #define CORE_FREQ		140000
 #define SYSCLK			140000000
#elif CPU_FRQ_130MHZ
 #define CORE_FREQ		130000
 #define SYSCLK			130000000
#elif CPU_FRQ_120MHZ
 #define CORE_FREQ		120000
 #define SYSCLK			120000000
#elif CPU_FRQ_200MHZ
 #define CORE_FREQ		200000
 #define SYSCLK			200000000
#else
 #error "CPU frequency undefined"
 #undef CORE_FREQ
 #undef SYSCLK
#endif


#ifdef __cplusplus
extern "C" {
#endif

//---------------------------------------------------------------------------
//! Watchdog Stuff
//---------------------------------------------------------------------------
#define NUM_OF_IRQS_BEFORE_RESET	10		//!< Number of watchdog IRQ requests before set the watchdog in RESET mode

#ifdef __cplusplus
}
#endif                                  /* extern "C" */

#endif /* __application_h__ */
