/*
 * FM25V05_Flash.h
 *
 *  Created on: 12.01.2016
 *      Author: richterr
 *
 *	Interface of Cypress FM25V05 SPI F-RAM
 *
 */

#ifndef _FM25V05_FLASH_H_
#define _FM25V05_FLASH_H_

// *************************************************************************
// Includes
// *************************************************************************
#include "compiler.h"
#include "SPI_Flash.h"

// *************************************************************************
// Definitions
// *************************************************************************

// *************************************************************************
// Declarations
// *************************************************************************
// Specific FM25V05 flash commands
class FM25V05_FlashSpecificCmds {
protected:
///	static const Uint16 Cmd = 0;
	static const Uint16 CmdDummy1 = 0x0123;
};

// class of complete flash device commands
class FM25V05_FlashCmds : public FlashCommonCmds, public FM25V05_FlashSpecificCmds { };

class FM25V05_Flash : public SpiFlash, public FM25V05_FlashCmds {
public:
	FM25V05_Flash();
	virtual ~FM25V05_Flash();
	FLASH_API_STATUS_MESSAGES InitSPI(void);
	FLASH_API_STATUS_MESSAGES VerifyDeviceId(const Uint32 DevId);
	Uint32 ReadDeviceId(void);				// Own method of the FM25V05, because of non standard device ID
};

// project global object of SPI-FRAM
extern FM25V05_Flash goSpiFRAM;

#endif // _FM25V05_FLASH_H_
