/*
 * FPGA.h
 *
 *	Created on: 01.12.2015
 *		Author: richterr
 *
 *	Interface of FPGA
 *
 */

#ifndef __fpga_h__
#define __fpga_h__

// *************************************************************************
// Includes
// *************************************************************************
#include "compiler.h"
//- #include "F2837xD_device.h"
#include "UART_COM1.h"

// *************************************************************************
// Definitions
// *************************************************************************
// Extender = 2 in case of FPGA address offset 'REG_OFFSET' = 1 (DefRegisterAddresses.vhd) and lines
//  'EMxBA' und 'EM2WAIT' are not contected between DSP anf FPGA (Board version: TT3100-A1).
//  Set Extender = 1 then 'EMxBA' und 'EM2WAIT' will be contected between DSP anf FPGA.
#define OFFSET_EXTENDER	2

// fix addresses of FPGA
#define FPGA_ADDR_VERSION_BOARD				0
#define FPGA_ADDR_VERSION_VARIANT			1
#define FPGA_ADDR_VERSION_BUILD				2
#define FPGA_ADDR_VERSION_STATE				3
#define FPGA_ADDR_VERSION_YEAR				4
#define FPGA_ADDR_VERSION_MONTH				5
#define FPGA_ADDR_VERSION_DAY				6
#define FPGA_ADDR_VERSION_HOURS				7
#define FPGA_ADDR_VERSION_MINUTES			8
#define FPGA_ADDR_VERSION_SECONDS			9

// *************************************************************************
// Declarations
// *************************************************************************
class FPGA {
public:
	// Document: N:\pA_Datenblaetter\IC_s_allg\Texas_Instruments\TMS320F2837xD_TI.pdf (SPRS880C DECEMBER 2013)
	//	Chapter: 6.3.3 EMIF Chip Select Memory Map
	//  EMIF2 CS2 address range -> 4x1024 Words
	static const Uint32 FpgaSizeInWords = 0x00001000;


	FPGA();
	virtual ~FPGA();

	Uint16 InitEMIF2(void);
	Uint32 GetEMIF2Status(void);
	void SetDebugCOM(UART_COM1* const COM);
	Uint16 ReadInteger(const Uint32 Address);
	void WriteInteger(const Uint32 Address, const Uint16 Value);
	void EnableJTAG(void);
	void DisableJTAG(void);
	void SetJTAG_TCK(const unsigned char aValue);
	void SetJTAG_TMS(const unsigned char aValue);
	void SetJTAG_TDI(const unsigned char aValue);
	unsigned char GetJTAG_TDO(void);

protected:
	// Document: N:\pA_Datenblaetter\IC_s_allg\Texas_Instruments\TMS320F2837xD_TI.pdf (SPRS880C DECEMBER 2013)
	//	Chapter: 6.3.3 EMIF Chip Select Memory Map
	static const Uint32 FpgaStartAddr = 0x00002000;		// EMIF2 CS2
	static const Uint32 EmifEndAddr = 0x00002FFF;		// EMIF2 CS2

private:
	UART_COM1* poCOM1;
};

// project global object of FPGA
extern FPGA goFPGA;

#endif // __fpga_h__
