/*
 * GPIO_pin_assignment.h
 *
 *  Created on: 14.12.2015
 *      Author: richterr
 *
 *
 */

#ifndef _GPIO_PIN_ASSIGNMENT_H_
#define _GPIO_PIN_ASSIGNMENT_H_

/* ********************************************************************
* Pin assignment: assign TT3100 function to GPIO pins on the F2837xD
********************************************************************* */

//		TT3100			Pin				GPIO Mux Selection Index (Document: TMS320F2837xD Dual-Core Delfino Microcontrollers; ID: SPRS880C)
//		Pinname			no	 0,4,8,12	 1	 				 2					 3					 5					 6					 7					 15
#define GPIO_0			0	// GPIO0,	EPWM1A (O),																		SDAA (I/OD)
#define GPIO_1			1	// GPIO1,	EPWM1B (O),								MFSRB (I/O),							SCLA (I/OD)
#define JMP_DSP1		2	// GPIO2,	EPWM2A (O),													OUTPUTXBAR1 (O),	SDAB (I/OD)
#define JMP_DSP2		3	// GPIO3,	EPWM2B (O),			OUTPUTXBAR2 (O),	MCLKRB (I/O),		OUTPUTXBAR2 (O),	SCLB (I/OD)
#define CAN1_TXD		4	// GPIO4,	EPWM3A (O),													OUTPUTXBAR3 (O),	CANTXA (O)
#define CAN1_RXD		5	// GPIO5,	EPWM3B (O),			MFSRA (I/O),		OUTPUTXBAR3 (O),						CANRXA (I)
#define CAN2_TXD		6	// GPIO6,	EPWM4A (O),			OUTPUTXBAR4 (O),	EPWMSYNCO (O),		EQEP3A (I),			CANTXB (O)
#define CAN2_RXD		7	// GPIO7,	EPWM4B (O),			MCLKRA (I/O),		OUTPUTXBAR5 (O),	EQEP3B (I),			CANRXB (I)
#define COM1_TX			8	// GPIO8,	EPWM5A (O),			CANTXB (O),			ADCSOCAO (O),		EQEP3S (I/O),		SCITXDA (O)
#define COM1_RX			9	// GPIO9,	EPWM5B (O),			SCITXDB (O),		OUTPUTXBAR6 (O),	EQEP3I (I/O),		SCIRXDA (I)
#define GPIO_10			10	// GPIO10,	EPWM6A (O),			CANRXB (I),			ADCSOCBO (O),		EQEP1A (I),			SCITXDB (O),							UPP-WAIT (I/O)
#define GPIO_11			11	// GPIO11,	EPWM6B (O),			SCIRXDB (I),		OUTPUTXBAR7 (O),	EQEP1B (I),			SCIRXDB (I),							UPP-STRT (I/O)
#define GPIO_12			12	// GPIO12,	EPWM7A (O),			CANTXB (O),			MDXB (O),			EQEP1S (I/O),		SCITXDC (O),							UPP-ENA (I/O)
#define GPIO_13			13	// GPIO13,	EPWM7B (O),			CANRXB (I),			MDRB (I),			EQEP1I (I/O),		SCIRXDC (I),							UPP-D7 (I/O)
#define COM2_TX			14	// GPIO14,	EPWM8A (O),			SCITXDB (O),		MCLKXB (I/O),							OUTPUTXBAR3 (O),						UPP-D6 (I/O)
#define COM2_RX			15	// GPIO15,	EPWM8B (O),			SCIRXDB (I),		MFSXB (I/O),							OUTPUTXBAR4 (O),						UPP-D5 (I/O)
#define SPISIMOA		16	// GPIO16,	SPISIMOA (I/O),		CANTXB (O),			OUTPUTXBAR7 (O),	EPWM9A (O),								SD1_D1 (I),			UPP-D4 (I/O)
#define SPISOMIA		17	// GPIO17,	SPISOMIA (I/O),		CANRXB (I),			OUTPUTXBAR8 (O),	EPWM9B (O),								SD1_C1 (I),			UPP-D3 (I/O)
#define SPICLKA			18	// GPIO18,	SPICLKA (I/O),		SCITXDB (O),		CANRXA (I),			EPWM10A (O),							SD1_D2 (I),			UPP-D2 (I/O)
#define SPIEA_N			19	// GPIO19,	SPISTEA (I/O),		SCIRXDB (I),		CANTXA (O),			EPWM10B (O),							SD1_C2 (I),			UPP-D1 (I/O)
#define GPIO_20			20	// GPIO20,	EQEP1A (I),			MDXA (O),			CANTXB (O),			EPWM11A (O),							SD1_D3 (I),			UPP-D0 (I/O)
#define DSP_LED			21	// GPIO21,	EQEP1B (I),			MDRA (I),			CANRXB (I),			EPWM11B (O),							SD1_C3 (I),			UPP-CLK (I/O)
#define GPIO_22			22	// GPIO22,	EQEP1S (I/O),		MCLKXA (I/O),		SCITXDB (O),		EPWM12A (O),		SPICLKB (I/O),		SD1_D4 (I)
#define GPIO_23			23	// GPIO23,	EQEP1I (I/O),		MFSXA (I/O),		SCIRXDB (I),		EPWM12B (O),		SPISTEB (I/O),		SD1_C4 (I)
#define GPIO_24			24	// GPIO24,	OUTPUTXBAR1 (O),	EQEP2A (I),			MDXB (O),								SPISIMOB (I/O),		SD2_D1 (I)
#define GPIO_25			25	// GPIO25,	OUTPUTXBAR2 (O),	EQEP2B (I),			MDRB (I),								SPISOMIB (I/O),		SD2_C1 (I)
#define HWREF3			26	// GPIO26,	OUTPUTXBAR3 (O),	EQEP2I (I/O),		MCLKXB (I/O),		OUTPUTXBAR3 (O),	SPICLKB (I/O),		SD2_D2 (I)
#define HWREF2			27	// GPIO27,	OUTPUTXBAR4 (O),	EQEP2S (I/O),		MFSXB (I/O),		OUTPUTXBAR4 (O),	SPISTEB (I/O),		SD2_C2 (I)
// *********** CS4 not used in schematic and layout until now ***************
#define CS4_RAM_N__TODO			28	// GPIO28,	SCIRXDA (I),		EM1CS4 (O),								OUTPUTXBAR5 (O),	EQEP3A (I),			SD2_D3 (I)
#define CKE				29	// GPIO29,	SCITXDA (O),		EM1SDCKE (O),							OUTPUTXBAR6 (O),	EQEP3B (I),			SD2_C3 (I)
#define CLK				30	// GPIO30,	CANRXA (I),			EM1CLK (O),								OUTPUTXBAR7 (O),	EQEP3S (I/O),		SD2_D4 (I)
#define WE_N			31	// GPIO31,	CANTXA (O),			EM1WE (O),								OUTPUTXBAR8 (O),	EQEP3I (I/O),		SD2_C4 (I)
#define CS0_RAM_N		32	// GPIO32,	SDAA (I/OD),		EM1CS0 (O)
#define GPIO_33			33	// GPIO33,	SCLA (I/OD),		EM1RNW (O)
// *********** CS2 not used in schematic and layout until now ***************
#define CS2_RAM_N__TODO	34	// GPIO34,	OUTPUTXBAR1 (O),	EM1CS2 (O),													SDAB (I/OD)
// *********** CS3 not used in schematic and layout until now ***************
#define CS3_RAM_N__TODO	35	// GPIO35,	SCIRXDA (I),		EM1CS3 (O),													SCLB (I/OD)
#define DSP_FPGA1		36	// GPIO36,	SCITXDA (O),		EM1WAIT (I),												CANRXA (I)
#define GPIO_37			37	// GPIO37,	OUTPUTXBAR2 (O),	EM1OE (O),													CANTXA (O)
#define A0				38	// GPIO38,						EM1A0 (O),								SCITXDC (O),		CANTXB (O)
#define A1				39	// GPIO39,						EM1A1 (O),								SCIRXDC (I),		CANRXB (I)

//		Pinname			no	 0,4,8,12	 1	 				 2					 3					 5					 6					 7					 15
#define A2				40	// GPIO40,						EM1A2 (O),													SDAB (I/OD)
#define A3				41	// GPIO41,						EM1A3 (O),													SCLB (I/OD)
#define FPGA_TDO		42	// GPIO42,																					SDAA (I/OD),							SCITXDA (O)
#define FPGA_TCK		43	// GPIO43,																					SCLA (I/OD),							SCIRXDA (I)
#define A4				44	// GPIO44,						EM1A4 (O)
#define A5				45	// GPIO45,						EM1A5 (O)
#define A6				46	// GPIO46,						EM1A6 (O),													SCIRXDD (I)
#define A7				47	// GPIO47,						EM1A7 (O),													SCITXDD (O)
#define A8				48	// GPIO48,	OUTPUTXBAR3 (O),	EM1A8 (O),													SCITXDA (O),		SD1_D1 (I)
#define A9				49	// GPIO49,	OUTPUTXBAR4 (O),	EM1A9 (O),													SCIRXDA (I),		SD1_C1 (I)
#define A10				50	// GPIO50,	EQEP1A (I),			EM1A10 (O),													SPISIMOC (I/O),		SD1_D2 (I)
#define A11				51	// GPIO51,	EQEP1B (I),			EM1A11 (O),													SPISOMIC (I/O),		SD1_C2 (I)
#define A12				52	// GPIO52,	EQEP1S (I/O),		EM1A12 (O),													SPICLKC (I/O),		SD1_D3 (I)
#define FD15			53	// GPIO53,	EQEP1I (I/O),		EM1D31 (I/O),		EM2D15 (I/O),							SPISTEC (I/O),		SD1_C3 (I)
#define FD14			54	// GPIO54,	SPISIMOA (I/O),		EM1D30 (I/O),		EM2D14 (I/O),		EQEP2A (I),			SCITXDB (O),		SD1_D4 (I)
#define FD13			55	// GPIO55,	SPISOMIA (I/O),		EM1D29 (I/O),		EM2D13 (I/O),		EQEP2B (I),			SCIRXDB (I),		SD1_C4 (I)
#define FD12			56	// GPIO56,	SPICLKA (I/O),		EM1D28 (I/O),		EM2D12 (I/O),		EQEP2S (I/O),		SCITXDC (O),		SD2_D1 (I)
#define FD11			57	// GPIO57,	SPISTEA (I/O),		EM1D27 (I/O),		EM2D11 (I/O),		EQEP2I (I/O),		SCIRXDC (I),		SD2_C1 (I)
#define FD10			58	// GPIO58,	MCLKRA (I/O),		EM1D26 (I/O),		EM2D10 (I/O),		OUTPUTXBAR1 (O),	SPICLKB (I/O),		SD2_D2 (I),			SPISIMOA (I/O)
#define FD9				59	// GPIO59,	MFSRA (I/O),		EM1D25 (I/O),		EM2D9 (I/O),		OUTPUTXBAR2 (O),	SPISTEB (I/O),		SD2_C2 (I),			SPISOMIA (I/O)
#define FD8				60	// GPIO60,	MCLKRB (I/O),		EM1D24 (I/O),		EM2D8 (I/O),		OUTPUTXBAR3 (O),	SPISIMOB (I/O),		SD2_D3 (I),			SPICLKA (I/O)
#define FD7				61	// GPIO61,	MFSRB (I/O),		EM1D23 (I/O),		EM2D7 (I/O),		OUTPUTXBAR4 (O),	SPISOMIB (I/O),		SD2_C3 (I),			SPISTEA (I/O)
#define FD6				62	// GPIO62,	SCIRXDC (I),		EM1D22 (I/O),		EM2D6 (I/O),		EQEP3A (I),			CANRXA (I),			SD2_D4 (I)
#define FD5				63	// GPIO63,	SCITXDC (O),		EM1D21 (I/O),		EM2D5 (I/O),		EQEP3B (I),			CANTXA (O),			SD2_C4 (I),			SPISIMOB (I/O)
#define FD4				64	// GPIO64,						EM1D20 (I/O),		EM2D4 (I/O),		EQEP3S (I/O),		SCIRXDA (I),							SPISOMIB (I/O)
#define FD3				65	// GPIO65,						EM1D19 (I/O),		EM2D3 (I/O),		EQEP3I (I/O),		SCITXDA (O),							SPICLKB (I/O)
#define FD2				66	// GPIO66,						EM1D18 (I/O),		EM2D2 (I/O),							SDAB (I/OD),							SPISTEB (I/O)
#define FD1				67	// GPIO67,						EM1D17 (I/O),		EM2D1 (I/O)
#define FD0				68	// GPIO68,						EM1D16 (I/O),		EM2D0 (I/O)
#define D15				69	// GPIO69,						EM1D15 (I/O),												SCLB (I/OD),							SPISIMOC (I/O)
#define D14				70	// GPIO70,						EM1D14 (I/O),							CANRXA (I),			SCITXDB (O),							SPISOMIC (I/O)
#define D13				71	// GPIO71,						EM1D13 (I/O),							CANTXA (O),			SCIRXDB (I),							SPICLKC (I/O)
#define D12_BOOT1		72	// GPIO72,						EM1D12 (I/O),							CANTXB (O),			SCITXDC (O),							SPISTEC (I/O)
#define D11				73	// GPIO73,						EM1D11 (I/O),		XCLKOUT (O),		CANRXB (I),			SCIRXDC (I)
#define D10				74	// GPIO74,						EM1D10 (I/O)
#define D9				75	// GPIO75,						EM1D9 (I/O)
#define D8				76	// GPIO76,						EM1D8 (I/O),												SCITXDD (O)
#define D7				77	// GPIO77,						EM1D7 (I/O),												SCIRXDD (I)
#define D6				78	// GPIO78,						EM1D6 (I/O),												EQEP2A (I)
#define D5				79	// GPIO79,						EM1D5 (I/O),												EQEP2B (I)
#define D4				80	// GPIO80,						EM1D4 (I/O),												EQEP2S (I/O)
#define D3				81	// GPIO81,						EM1D3 (I/O),												EQEP2I (I/O)
#define D2				82	// GPIO82,						EM1D2 (I/O)
#define D1				83	// GPIO83,						EM1D1 (I/O)
#define BOOT0			84	// GPIO84,																SCITXDA (O),		MDXB (O),								MDXA (O)
#define D0				85	// GPIO85,						EM1D0 (I/O),							SCIRXDA (I),		MDRB (I),								MDRA (I)
#define A13_CAS_N		86	// GPIO86,						EM1A13 (O),			EM1CAS (O),			SCITXDB (O),		MCLKXB (I/O),							MCLKXA (I/O)
#define A14_RAS_N		87	// GPIO87,						EM1A14 (O),			EM1RAS (O),			SCIRXDB (I),		MFSXB (I/O),							MFSXA (I/O)
#define A15_DQML		88	// GPIO88,						EM1A15 (O),			EM1DQM0 (O)
#define EM1DQM1			89	// GPIO89,						EM1A16 (O),			EM1DQM1 (O),							SCITXDC (O)

//		Pinname			no	 0,4,8,12	 1	 				 2					 3					 5					 6					 7					 15
#define GPIO_90			90	// GPIO90,						EM1A17 (O),			EM1DQM2 (O),							SCIRXDC (I)
#define GPIO_91			91	// GPIO91,						EM1A18 (O),			EM1DQM3 (O),							SDAA (I/OD)
#define BA1				92	// GPIO92,						EM1A19 (O),			EM1BA1 (O),								SCLA (I/OD)
#define BA0				93	// GPIO93,											EM1BA0 (O),								SCITXDD (O)
#define TEST_DSP1		94	// GPIO94,																					SCIRXDD (I)
#define TEST_DSP2		95	// GPIO95
#define GPIO_96			96	// GPIO96,											EM2DQM1 (O),		EQEP1A (I)
#define GPIO_97			97	// GPIO97,											EM2DQM0 (O),		EQEP1B (I)
#define FA0				98	// GPIO98,											EM2A0 (O),			EQEP1S (I/O)
#define FA1				99	// GPIO99,											EM2A1 (O),			EQEP1I (I/O)
#define FA2				100	// GPIO100,											EM2A2 (O),			EQEP2A (I),			SPISIMOC (I/O)
#define FA3				101	// GPIO101,											EM2A3 (O),			EQEP2B (I),			SPISOMIC (I/O)
#define FA4				102	// GPIO102,											EM2A4 (O),			EQEP2S (I/O),		SPICLKC (I/O)
#define FA5				103	// GPIO103,											EM2A5 (O),			EQEP2I (I/O),		SPISTEC (I/O)
#define FA6				104	// GPIO104,	SDAA (I/OD),							EM2A6 (O),			EQEP3A (I),			SCITXDD (O)
#define FA7				105	// GPIO105,	SCLA (I/OD),							EM2A7 (O),			EQEP3B (I),			SCIRXDD (I)
#define FA8				106	// GPIO106,											EM2A8 (O),			EQEP3S (I/O),		SCITXDC (O)
#define FA9				107	// GPIO107,											EM2A9 (O),			EQEP3I (I/O),		SCIRXDC (I)
#define FA10			108	// GPIO108,											EM2A10 (O)
#define FA11			109	// GPIO109,											EM2A11 (O)
#define HWREF1			110	// GPIO110,											EM2WAIT (I)
#define GPIO_111		111	// GPIO111,											EM2BA0 (O)
#define GPIO_112		112	// GPIO112,											EM2BA1 (O)
#define GPIO_113		113	// GPIO113,											EM2CAS (O)
#define GPIO_114		114	// GPIO114,											EM2RAS (O)
#define CS0_FPGA_N		115	// GPIO115,											EM2CS0 (O)
#define CS2_FPGA_N		116	// GPIO116,											EM2CS2 (O)
#define GPIO_117		117	// GPIO117,											EM2SDCKE (O)
#define EM2CLK			118	// GPIO118,											EM2CLK (O)
#define FRW_N			119	// GPIO119,											EM2RNW (O)
#define FWE_N			120	// GPIO120,											EM2WE (O),																	USB0PFLT
#define FOE_N			121	// GPIO121,											EM2OE (O),																	USB0EPEN
#define SPISIMOC		122	// GPIO122,																					SPISIMOC (I/O),		SD1_D1 (I)
#define SPISOMIC		123	// GPIO123,																					SPISOMIC (I/O),		SD1_C1 (I)
#define SPICLKC			124	// GPIO124,																					SPICLKC (I/O),		SD1_D2 (I)
#define SPIEC_N			125	// GPIO125,																					SPISTEC (I/O),		SD1_C2 (I)
#define ENABLE_DRV34	126	// GPIO126,																										SD1_D3 (I)
#define ENABLE_DRV78	127	// GPIO127,																										SD1_C3 (I)
#define ENABLE_DRV1112	128	// GPIO128,																										SD1_D4 (I)
#define ENABLE_DRV12	129	// GPIO129,																										SD1_C4 (I)
#define ENABLE_DRV56	130	// GPIO130,																										SD2_D1 (I)
#define ENABLE_DRV910	131	// GPIO131,																										SD2_C1 (I)
#define TEST_FPGA1		132	// GPIO132,																										SD2_D2 (I)
#define GPIO_133		133	// GPIO133,																										SD2_C2 (I)
#define TEST_FPGA2		134	// GPIO134,																										SD2_D3 (I)
#define GPIO_135		135	// GPIO135,																					SCITXDA (O),		SD2_C3 (I)
#define GPIO_136		136	// GPIO136,																					SCIRXDA (I),		SD2_D4 (I)
#define INT0			137	// GPIO137,																					SCITXDB (O),		SD2_C4 (I)
#define INT1			138	// GPIO138,																					SCIRXDB (I)
#define GPIO_139		139	// GPIO139,																					SCIRXDC (I)
#define GPIO_140		140	// GPIO140,																					SCITXDC (O)

//		Pinname			no	 0,4,8,12	 1	 				 2					 3					 5					 6					 7					 15
#define GPIO_141		141	// GPIO141,																					SCIRXDD (I)
#define GPIO_142		142	// GPIO142,																					SCITXDD (O)
#define FPGA_TDI		143	// GPIO143
#define FPGA_TMS		144	// GPIO144
#define PWM1A_DSP		145	// GPIO145,	EPWM1A (O)
#define PWM1B_DSP		146	// GPIO146,	EPWM1B (O)
#define PWM2A_DSP		147	// GPIO147,	EPWM2A (O)
#define PWM2B_DSP		148	// GPIO148,	EPWM2B (O)
#define PWM3A_DSP		149	// GPIO149,	EPWM3A (O)
#define PWM3B_DSP		150	// GPIO150,	EPWM3B (O)
#define PWM4A_DSP		151	// GPIO151,	EPWM4A (O)
#define PWM4B_DSP		152	// GPIO152,	EPWM4B (O)
#define PWM5A_DSP		153	// GPIO153,	EPWM5A (O)
#define PWM5B_DSP		154	// GPIO154,	EPWM5B (O)
#define PWM6A_DSP		155	// GPIO155,	EPWM6A (O)
#define PWM6B_DSP		156	// GPIO156,	EPWM6B (O)
#define PWM7A_DSP		157	// GPIO157,	EPWM7A (O)
#define PWM7B_DSP		158	// GPIO158,	EPWM7B (O)
#define PWM8A_DSP		159	// GPIO159,	EPWM8A (O)
#define PWM8B_DSP		160	// GPIO160,	EPWM8B (O)
#define PWM9A_DSP		161	// GPIO161,	EPWM9A (O)
#define PWM9B_DSP		162	// GPIO162,	EPWM9B (O)
#define PWM10A_DSP		163	// GPIO163,	EPWM10A (O)
#define PWM10B_DSP		164	// GPIO164,	EPWM10B (O)
#define PWM11A_DSP		165	// GPIO165,	EPWM11A (O)
#define PWM11B_DSP		166	// GPIO166,	EPWM11B (O)
#define PWM12A_DSP		167	// GPIO167,	EPWM12A (O)
#define PWM12B_DSP		168	// GPIO168,	EPWM12B (O)

#endif // _GPIO_PIN_ASSIGNMENT_H_
