/*
 * PWM.cpp
 *
 *  Created on: 09.02.2016
 *      Author: richterr
 *
 *	Interface of Pulse Width Modulation ports
 *
 */

#include "F28x_Project.h"		// Device Headerfile and Examples Include File
//-#include "F2837xD_EPwm_defines.h"
#include <PWM.h>

using namespace std;

// *************************************************************************
// Global variables, structures, etc
// *************************************************************************
/*
struct
{
    volatile struct EPWM_REGS* RegHandle;
    Uint16 DirectionCMPA;
    Uint16 DirectionCMPB;
    Uint16 TimerIntCount;
    Uint16 MaxCMPA;
    Uint16 MinCMPA;
    Uint16 MaxCMPB;
    Uint16 MinCMPB;
} EPWM_PARAM;

// parameters of each PWM
EPWM_PARAM ParamPwm1;
// */
class PwmParam oParam1;

// *************************************************************************
// Definitions
// *************************************************************************
PWM::PWM() {
	// TODO Auto-generated constructor stub
}

PWM::~PWM() {
	// TODO Auto-generated destructor stub
}

/***************** doxygen like ******************************//**
 * Method: Init
 * In: ClockDivider: Clock ratio to SYSCLKOUT
 * Out: ---
 * Description: Initialazation of PWM interface. Set initerrupts, default parameters (All off), etc.
// **************************************************************/
void PWM::Init(Uint16 const ClockDivider) {
	EALLOW; // This is needed to write to EALLOW protected registers
	PieVectTable.EPWM1_INT = &epwm1_isr;
/*	PieVectTable.EPWM2_INT = &epwm2_isr;
	PieVectTable.EPWM3_INT = &epwm3_isr;
	PieVectTable.EPWM4_INT = &epwm4_isr;
	PieVectTable.EPWM5_INT = &epwm5_isr;
	PieVectTable.EPWM6_INT = &epwm6_isr;
	PieVectTable.EPWM7_INT = &epwm7_isr;
	PieVectTable.EPWM8_INT = &epwm8_isr;
	PieVectTable.EPWM9_INT = &epwm9_isr;
	PieVectTable.EPWM10_INT = &epwm10_isr;
	PieVectTable.EPWM11_INT = &epwm11_isr;
	PieVectTable.EPWM12_INT = &epwm12_isr;
// */
	EDIS;   // This is needed to disable write to EALLOW protected registers

	// Clock divider
	ClkDiv = ClockDivider;
	if(TB_DIV4 < ClkDiv) {
		ClkDiv = TB_DIV4;
	}

	// Init parameters of PWM1
//-	oParam1.RegHandle = &EPwm1Regs;
	oParam1.MaxCMPA = 0;
	oParam1.MinCMPA = 0;
	oParam1.MaxCMPB = 0;
	oParam1.MinCMPB = 0;
	oParam1.NewParam = false;

	return;
}

/***************** doxygen like ******************************//**
 * Method:
 * In: ---
 * Out: ---
 * Description: .
// **************************************************************/

/***************** doxygen like ******************************//**
 * Method: Enable
 * In: ---
 * Out: ---
 * Description: Enable PWM output.
// **************************************************************/
void PWM::Enable(Uint16 const PwmNo)
{
	EALLOW;
	CpuSysRegs.PCLKCR0.bit.TBCLKSYNC =1;
	EDIS;

	// Enable CPU INT3 which is connected to EPWM1-3 INT:
	IER |= M_INT3;

	// Enable EPWM INTn in the PIE: Group 3 interrupt 1-4
	switch (PwmNo) {
	case 1:
		PieCtrlRegs.PIEIER3.bit.INTx1 = 1;
		break;
	case 2:
		PieCtrlRegs.PIEIER3.bit.INTx2 = 1;
		break;
	case 3:
		PieCtrlRegs.PIEIER3.bit.INTx3 = 1;
		break;
	case 4:
		PieCtrlRegs.PIEIER3.bit.INTx4 = 1;
		break;
	case 5:
		PieCtrlRegs.PIEIER3.bit.INTx5 = 1;
		break;
	case 6:
		PieCtrlRegs.PIEIER3.bit.INTx6 = 1;
		break;
	case 7:
		PieCtrlRegs.PIEIER3.bit.INTx7 = 1;
		break;
	case 8:
		PieCtrlRegs.PIEIER3.bit.INTx8 = 1;
		break;
	case 9:
		PieCtrlRegs.PIEIER3.bit.INTx9 = 1;
		break;
	case 10:
		PieCtrlRegs.PIEIER3.bit.INTx10 = 1;
		break;
	case 11:
		PieCtrlRegs.PIEIER3.bit.INTx11 = 1;
		break;
	case 12:
		PieCtrlRegs.PIEIER3.bit.INTx12 = 1;
		break;
	default:
		break;
	}

	// Enable global Interrupts and higher priority real-time debug events:
    EINT;  // Enable Global interrupt INTM
    ERTM;  // Enable Global realtime interrupt DBGM

	return;
}

/***************** doxygen like ******************************//**
 * Method: Disable
 * In: ---
 * Out: ---
 * Description: Disable PWM output.
// **************************************************************/
void PWM::Disable(Uint16 const PwmNo)
{
	EALLOW;
	CpuSysRegs.PCLKCR0.bit.TBCLKSYNC =0;
	EDIS;

	// Enable EPWM INTn in the PIE: Group 3 interrupt 1-4
	switch (PwmNo) {
	case 1:
		PieCtrlRegs.PIEIER3.bit.INTx1 = 0;
		break;
	case 2:
		PieCtrlRegs.PIEIER3.bit.INTx2 = 0;
		break;
	case 3:
		PieCtrlRegs.PIEIER3.bit.INTx3 = 0;
		break;
	case 4:
		PieCtrlRegs.PIEIER3.bit.INTx4 = 0;
		break;
	case 5:
		PieCtrlRegs.PIEIER3.bit.INTx5 = 0;
		break;
	case 6:
		PieCtrlRegs.PIEIER3.bit.INTx6 = 0;
		break;
	case 7:
		PieCtrlRegs.PIEIER3.bit.INTx7 = 0;
		break;
	case 8:
		PieCtrlRegs.PIEIER3.bit.INTx8 = 0;
		break;
	case 9:
		PieCtrlRegs.PIEIER3.bit.INTx9 = 0;
		break;
	case 10:
		PieCtrlRegs.PIEIER3.bit.INTx10 = 0;
		break;
	case 11:
		PieCtrlRegs.PIEIER3.bit.INTx11 = 0;
		break;
	case 12:
		PieCtrlRegs.PIEIER3.bit.INTx12 = 0;
		break;
	default:
		break;
	}

	return;
}

/***************** doxygen like ******************************//**
 * Method: SetParamsPwm1
 * In: ---
 * Out: ---
 * Description: .
// **************************************************************/
void PWM::SetParamsPwm1(Uint16 const Period, Uint16 const MaxCmpA, Uint16 const MinCmpA, Uint16 const MaxCmpB, Uint16 const MinCmpB)
{
	oParam1.MaxCMPA = MaxCmpA;
	oParam1.MinCMPA = MinCmpA;
	oParam1.MaxCMPB = MaxCmpB;
	oParam1.MinCMPB = MinCmpB;
	oParam1.NewParam = true;

	Disable(1);
	SetParameter(&EPwm1Regs, &oParam1, Period, MaxCmpA, MaxCmpB, MinCmpA, MinCmpB);
	Enable(1);
	return;
}

/***************** doxygen like ******************************//**
 * Method: SetParameter
 * In: ---
 * Out: ---
 * Description: .
// **************************************************************/
void PWM::SetParameter(volatile struct EPWM_REGS* const EPwmRegs, PwmParam* const poParams, Uint16 const Period,
			 Uint16 const MaxCmpA, Uint16 const MinCmpA, Uint16 const MaxCmpB, Uint16 const MinCmpB)
{
	EALLOW;
	CpuSysRegs.PCLKCR0.bit.TBCLKSYNC =0;
	EDIS;

	// Setup TBCLK
	EPwmRegs->TBCTL.bit.CTRMODE = TB_COUNT_UP;	// Count up
	EPwmRegs->TBPRD = Period;					// Set timer period
	EPwmRegs->TBCTL.bit.PHSEN = TB_DISABLE;		// Disable phase loading
	EPwmRegs->TBPHS.bit.TBPHS = 0x0000;			// Phase is 0
	EPwmRegs->TBCTR = 0x0000;					// Clear counter
	EPwmRegs->TBCTL.bit.HSPCLKDIV = ClkDiv;		// Clock ratio to SYSCLKOUT
	EPwmRegs->TBCTL.bit.CLKDIV = ClkDiv;

	// Setup shadow register load on ZERO
	EPwmRegs->CMPCTL.bit.SHDWAMODE = CC_SHADOW;
	EPwmRegs->CMPCTL.bit.SHDWBMODE = CC_SHADOW;
	EPwmRegs->CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;
	EPwmRegs->CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;

	// Set Compare values
	EPwmRegs->CMPA.bit.CMPA = MaxCmpA;    		// Set compare A value
	EPwmRegs->CMPB.bit.CMPB = MinCmpB;    		// Set Compare B value

	// Set actions
	EPwmRegs->AQCTLA.bit.ZRO = AQ_SET;			// Set PWM1A on Zero
	EPwmRegs->AQCTLA.bit.CAU = AQ_CLEAR;		// Clear PWM1A on event A, up count

	EPwmRegs->AQCTLB.bit.ZRO = AQ_SET;			// Set PWM1B on Zero
	EPwmRegs->AQCTLB.bit.CBU = AQ_CLEAR;		// Clear PWM1B on event B, up count

	// Interrupt where we will change the Compare Values
	EPwmRegs->ETSEL.bit.INTSEL = ET_CTR_ZERO;	// Select INT on Zero event
	EPwmRegs->ETSEL.bit.INTEN = 1;				// Enable INT
	EPwmRegs->ETPS.bit.INTPRD = ET_3RD;			// Generate INT on 3rd event

	return;
}

/***************** doxygen like ******************************//**
 * Method:
 * In: ---
 * Out: ---
 * Description: .
// **************************************************************/
/*
void PWM::UpdateComparators(PwmParam* const poParams)
{
	return;
}
// */

/***************** doxygen like ******************************//**
 * Method:
 * In: ---
 * Out: ---
 * Description: .
// **************************************************************/
__interrupt void PWM::epwm1_isr(void)
{
    // Update the CMPA and CMPB values
//~    update_compare(&epwm1_info);

    // Clear INT flag for this timer
    EPwm1Regs.ETCLR.bit.INT = 1;

    // Acknowledge this interrupt to receive more interrupts from group 3
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;
}
