/*
 * PWM.h
 *
 *  Created on: 09.02.2016
 *      Author: richterr
 *
 *	Interface of Pulse Width Modulation ports
 *
 */

#ifndef __pwm_h__
#define __pwm_h__

// *************************************************************************
// Includes
// *************************************************************************
#include <F2837xD_Device.h> // DSP2837xD header file peripheral address definitions

// *************************************************************************
// Definitions
// *************************************************************************

// *************************************************************************
// Declarations
// *************************************************************************
// subclass of parameters
class PwmParam {
public:
//-	volatile struct EPWM_REGS* RegHandle;
	Uint16 MaxCMPA;			// Comparator A: maximum value
	Uint16 MinCMPA;			// Comparator A: minimum value
	Uint16 MaxCMPB;			// Comparator B: maximum value
	Uint16 MinCMPB;			// Comparator B: minimum value
	bool NewParam;			// true = new values, update ePWM
};

class PWM : protected PwmParam {
public:
	PWM();
	virtual ~PWM();
	void Enable((Uint16 const PwmNo);
	void Disable((Uint16 const PwmNo);
	void Init(Uint16 const ClockDivider);
	void SetParamsPwm1(Uint16 const Period, Uint16 const MaxCmpA, Uint16 const MinCmpA, Uint16 const MaxCmpB, Uint16 const MinCmpB);

private:
	Uint16 ClkDiv;

	void SetParameter(volatile struct EPWM_REGS* const EPwmRegs, PwmParam* const poParams, Uint16 const Period,
					  Uint16 const MaxCmpA, Uint16 const MinCmpA, Uint16 const MaxCmpB, Uint16 const MinCmpB);
	void UpdateParams(PwmParam* const poParams);
	// Interrupt service routines
	static __interrupt void epwm1_isr(void);
	static __interrupt void epwm2_isr(void);
	static __interrupt void epwm3_isr(void);
	static __interrupt void epwm4_isr(void);
	static __interrupt void epwm5_isr(void);
	static __interrupt void epwm6_isr(void);
	static __interrupt void epwm7_isr(void);
	static __interrupt void epwm8_isr(void);
	static __interrupt void epwm9_isr(void);
	static __interrupt void epwm10_isr(void);
	static __interrupt void epwm11_isr(void);
	static __interrupt void epwm12_isr(void);
};

#endif /* __pwm_h__ */
