/*
 * SDRAM.h
 *
 *	Created on: 25.11.2015
 *		Author: richterr
 *
 *	Interface of SD-RAM
 *
 */

#ifndef __sdram_h__
#define __sdram_h__

// *************************************************************************
// Includes
// *************************************************************************
#include "F2837xD_device.h"
#include "UART_COM1.h"

// *************************************************************************
// Definitions
// *************************************************************************


// *************************************************************************
// Declarations
// *************************************************************************
class SDRAM {
public:
	// SD-RAM: IS45S16160G; 256M-bit Synchronous DRAM -> 16777216 Words
	static const Uint32 SDramSizeInWords = 0x01000000;


	SDRAM();
	virtual ~SDRAM();

	Uint16 InitOnCPU1(void);
	void SetDebugCOM(UART_COM1* const COM);
	Uint16 ReadInteger(const Uint32 Address);
	void WriteInteger(const Uint32 Address, const Uint16 Value);

	char test_read_write(Uint32 start_addr, Uint32 mem_size);

protected:
	// Document: N:\pA_Datenblaetter\IC_s_allg\Texas_Instruments\TMS320F2837xD_TI.pdf (SPRS880C DECEMBER 2013)
	//	Chapter: 6.3.3 EMIF Chip Select Memory Map
	static const Uint32 SDramStartAddr = 0x80000000;	// EMIF1 CS0
	static const Uint32 EmifEndAddr = 0x8FFFFFFF;		// EMIF1 CS0

private:
	UART_COM1* poCOM1;
};

// project global object of SD-RAM
extern SDRAM goSdram;

#endif // __sdram_h__
