/*
 * UART_COM1.h
 *
 *  Created on: 22.09.2015
 *      Author: richterr
 *
 *  Serial interface COM1 handling
 *
 */

#ifndef __uart_com1_h__
#define __uart_com1_h__

// *************************************************************************
// Includes
// *************************************************************************
#include <sstream>
#include "compiler.h"

// *************************************************************************
// Definitions
// *************************************************************************
#define RECEIVE_BUFFER_SIZE		32		// Size of receive buffer

// *************************************************************************
// C-style Declarations
// *************************************************************************
#ifdef __cplusplus
extern "C" {
 interrupt void COM1_RX_ISR(void);
 interrupt void COM1_TX_ISR(void);
}
#endif

// *************************************************************************
// Class Declaration
// *************************************************************************
class UART_COM1 {
public:
	UART_COM1();
	virtual ~UART_COM1();

	// Source: C:\KBApps\TI\controlSUITE\device_support\F2837xD\v160\F2837xD_examples_Cpu1\sci_echoback\cpu01\Example_2837xDSci_Echoback.c
	void Open(uint32_t const Baudrate, uint16_t const DataBytes, uint16_t const Parity, uint16_t const StopBits);
	void Close(void);
	void Write(const int a);
	void Write(const char* const msg);
	void Write(const std::stringstream& msg);
	void Write(const std::ostringstream& msg);
	uint16_t Read(const char* pBuf);
	void ResetTerminal(void);

private:
};

// project global object of COM 1
extern UART_COM1 goCOM1;

#endif // __uart_com1_h__
