/*
 * W25Q256FV_Flash.h
 *
 *  Created on: 23.12.2015
 *      Author: richterr
 *
 *	Interface of Winbond W25Q256FV SPI Flash
 *
 */

#ifndef _W25Q256FV_FLASH_H_
#define _W25Q256FV_FLASH_H_

// *************************************************************************
// Includes
// *************************************************************************
#include "compiler.h"
#include "SPI_Flash.h"

// *************************************************************************
// Definitions
// *************************************************************************

// *************************************************************************
// Declarations
// *************************************************************************
// Specific W25Q256FV flash commands
class W25Q256FV_FlashSpecificCmds {
protected:
///	static const Uint16 Cmd = 0;
	static const Uint16 CmdDummy1 = 0x0110;
};

// class of complete flash device commands
class W25Q256FV_FlashCmds : public FlashCommonCmds, public W25Q256FV_FlashSpecificCmds { };

class W25Q256FV_Flash : public SpiFlash, public W25Q256FV_FlashCmds {
public:
	W25Q256FV_Flash();
	virtual ~W25Q256FV_Flash();
	FLASH_API_STATUS_MESSAGES InitSPI(void);
	FLASH_API_STATUS_MESSAGES VerifyDeviceId(const Uint32 DevId);
};

// project global object of SPI-Flash
extern W25Q256FV_Flash goSpiFlash;

#endif // _W25Q256FV_FLASH_H_
