/* *********************************************************************
* Devices: TMS320F2837xD
* Author: Rudi Richter
* Description: Configures all GPIOS for the TT3100 board
********************************************************************* */
#ifndef __gpio_h__
#define __gpio_h__

// *************************************************************************
// Includes
// *************************************************************************
#include "F2837xD_device.h"
#include "GPIO_pin_assignment.h"

// *************************************************************************
// Defines
// *************************************************************************
#define FALSE 0
#define TRUE 1
#define GPIO_FLASH_TOGGLE_OUT_REG_ADDR (&GpioDataRegs.GPATOGGLE.all)
#define GPIO_FLASH_TOGGLE_OUT_REG_MASK ((Uint32)1 << 27)

/* ********************************************************************
* Declarations:
********************************************************************* */

class GPIO_Class
{
public:
	GPIO_Class();
	virtual ~GPIO_Class();

	void InitializeGpio(void);
	void SwitchDspLedOn(const bool on);
	void ToggleDspLed(void);
	int GetBootloaderJumperGPIO(void);
	int GetJumperDSP1(void);
	bool IsDriverEnabled(const unsigned int IndexPairOfDrivers);
	void EnableDriver(const unsigned int IndexPairOfDrivers);
	void DisableDriver(const unsigned int IndexPairOfDrivers);
	void EnableAllDrivers(void);
	void DisableAllDrivers(void);
	int GetInput(const int channel);

protected:
	// constants of PWM drivers
	static const unsigned int IndexDriverPair12 = 0;
	static const unsigned int IndexDriverPair34 = 1;
	static const unsigned int IndexDriverPair56 = 2;
	static const unsigned int IndexDriverPair78 = 3;
	static const unsigned int IndexDriverPair910 = 4;
	static const unsigned int IndexDriverPair1112 = 5;
	static const unsigned int DriverEnable = 1;
	static const unsigned int DriverDisable = 0;

private:

};

// project global object of GPIOs
extern GPIO_Class goGPIO;

#endif // __gpio_h__
