//***************************************************************************************
//
//***************************************************************************************
#include <msp430.h>

#define     MOSI                 BIT7  //xmt
#define     SCK                  BIT6
#define     MISO                 BIT5  //rcv

#define     RXD                  BIT1  // GSM RX
#define     TXD                  BIT2  // GSM TX

#define     PWLEN                4
#define     PHLEN                10
#define     DULEN                2
#define     NUMDURATIONS         4


#define     PROC_SPEED            8000000
#define     ONE_MS                PROC_SPEED/1000
#define     TWO_MS                PROC_SPEED/500
#define     FOUR_MS               PROC_SPEED/250
#define     EIGHT_MS              PROC_SPEED/125
#define     TEN_MS                PROC_SPEED/100
#define     TICKS_PER_SECOND      62

#define     DATA_BUF_FULL         7

#define     GSM_DATA_SIZE         20

char duration[NUMDURATIONS][DULEN];
char password [PWLEN];
char phone1 [PHLEN];
char phone2 [PHLEN];

char gsm_data [GSM_DATA_SIZE];
short gdi=0;

void Init_GSM (void);
void Check_GSM (void);
void Transmit(char TXchar);
/**
 * main.c
 */
int main(void)
{
    WDTCTL = WDTPW | WDTHOLD;   // stop watchdog timer
    /* Use Calibration values  for 8MHz    Clock   DCO*/
    DCOCTL =   0;
    BCSCTL1 = CALBC1_8MHZ;          // Set range
    DCOCTL = CALDCO_8MHZ;           // SMCLK = DCO = 8MHz

    // GPIO
    P1DIR |= MOSI + SCK;            // set MOSI and clock as output

    P2DIR |= BIT0 + BIT1+ BIT2;     // set kp columns as output

    // set up pins for UART
    P1SEL = RXD+TXD;
    P1SEL2 = RXD+TXD;

    /* Place   UCA0    in  Reset   to  be  configured  */
    UCA0CTL1   =   UCSWRST;
    /* Configure for UART   */
    UCA0CTL1   |=  UCSSEL_2;        //  SMCLK

    UCA0BR0 = 52;                   //8MHz, OSC16, 9600
    UCA0BR1 = 0;                    //((8MHz/9600)/16) = 52.08333
    UCA0MCTL = 0x10|UCOS16;         //UCBRFx=1,UCBRSx=0, UCOS16=1
    /* Take    UCA0    out of  reset   */
    UCA0CTL1   &=  ~UCSWRST;
    /* Enable USCI_A0 RX interrupt */
    IE2 |= UCA0RXIE;

    _BIS_SR(GIE);                   // Enter Active w/ interrupt

    Init_GSM ();

    //*************************************************************************************
    // Main loop
    //*************************************************************************************
            for(;;) {
                // see if something has come in from UI processor
 //               Check_SPI ();

                // see if mthere is data from GSM
 //               Check_GSM ();
                __delay_cycles(ONE_MS);
            }
}
//*************************************************************************************
// start up the GSM module
//*************************************************************************************
void Init_GSM (void)
{
    Transmit ('A');
    Transmit ('T');

}
//*************************************************************************************
// process message from GSM module
//*************************************************************************************
void Check_GSM (void)
{
    if (gsm_data[gdi-1]==0xa) {   // NL char

    }
}

//******************************************************************************************************************
// Function Transmits Character from TXchar to LCD
//
void Transmit(char TXchar)
{
    while  (!(IFG2 & UCA0TXIFG));    //  USCI_A0 TX  buffer  ready? need this!
    UCA0TXBUF  =  TXchar;

    __delay_cycles(ONE_MS);
    __delay_cycles(ONE_MS);
}
//******************************************************************************************************************
// Function Transmits Character from TXchar to LCD
//
__interrupt void USCI0RX_ISR(void)
{
    gsm_data[gdi]=UCA0RXBUF;
    gdi++;

}
