/*
 * udpHello.c
 *
 * This program implements a UDP echo server, which echos back any
 * input it receives.
 *
 * Copyright (C) 2007 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#include <ti/ndk/inc/netmain.h>
#include <xdc/std.h>
#include <xdc/runtime/IHeap.h>
#include <xdc/runtime/System.h>
#include <xdc/runtime/Error.h>
#include <xdc/runtime/Memory.h>
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>
#include <ti/sysbios/heaps/HeapBuf.h>
#include <ti/sysbios/heaps/HeapMem.h>

#include <ti/osal/SemaphoreP.h>

#define BUFFER_SIZE 64*4*1024
//
// dtask_udp_hello() - UDP Echo Server Daemon Function
// (SOCK_DGRAM, port 7)
//
// Returns "1" if socket 's' is still open, and "0" if its been closed
//
int dtask_udp_hello( SOCKET s, uint32_t unused )
{
    struct sockaddr_in sin1;
    struct timeval     to;
    int                i,tmp;
    char               *pBuf;
    void*             hBuffer;
    char ubuf[2000];

    (void)unused;

    // Configure our socket timeout to be 3 seconds
    to.tv_sec  = 1;
    to.tv_usec = 0;
    setsockopt( s, SOL_SOCKET, SO_SNDTIMEO, &to, sizeof( to ) );
    setsockopt( s, SOL_SOCKET, SO_RCVTIMEO, &to, sizeof( to ) );

    for(;;)
    {
        tmp = sizeof( sin1 );
        i = (int)recvncfrom( s, (void **)&pBuf, 0, (struct sockaddr *)&sin1, (int *)&tmp, &hBuffer );

        // Spit any data back out
        if( i >= 0 )
        {
            //sendto( s, ubuf, 1600, 0, (struct sockaddr *)&sin1, sizeof(sin1) );
            send(s, ubuf, 1600, 0 );
            recvncfree( hBuffer );
        }

    }

    // Since the socket is still open, return "1"
    // (we need to leave UDP sockets open)
    return(1);    
}

char buffer[BUFFER_SIZE];
char tx_buffer[BUFFER_SIZE];


SemaphoreP_Handle semHandle;

void sendHandler(UArg arg0, UArg arg1)
{
    SOCKET s = arg0;
    int  send_count,i,recv_count;
    fdOpenSession (TaskSelf ());

    for(i = 0; i < 1000; i++)
        tx_buffer[i] = i;



    if(fdShare((SOCKET)s)){
        System_printf("share failed\n");
    }

    while(1)
    {
       // UART_printf("\n\sendHandler SemaphoreP_pend before\n");
       // SemaphoreP_pend(semHandle1,SemaphoreP_WAIT_FOREVER);
      //  UART_printf("\n\sendHandler SemaphoreP_pend after\n");

        send_count = 0;

         SemaphoreP_pend(semHandle,BIOS_WAIT_FOREVER);
         while(send_count < BUFFER_SIZE)
         {
             send_count += send(s, tx_buffer+send_count, BUFFER_SIZE - send_count, 0 );
         }
         SemaphoreP_post(semHandle);
         UART_printf("\n\Sent bytes: %d\n", send_count);



        //UART_printf("\n\Sent bytes: %d\n", send_count);
        /*recv_count = 0;
               while(recv_count < 64*1024*4)
               {
                  recv_count += recv(s, buffer+recv_count, (64*1024*4) - recv_count, 0);
               }

               UART_printf("\n\rReceived bytes: %d\n", recv_count);*/

    }
    fdCloseSession(TaskSelf());
}

void schecule_send(SOCKET s)
{
    Task_Handle taskHandle;
     Task_Params taskParams;
     Error_Block eb;



      Task_Params_init(&taskParams);

      Error_init(&eb);

      taskParams.stackSize = OS_TASKSTKNORM;
      taskParams.priority = OS_TASKPRINORM;
      taskParams.arg0 = s;

      UART_printf("Delay before tcp handler\n");
      Task_sleep(100);

      UART_printf("After sleep tcp handler\n");
      taskHandle = Task_create((Task_FuncPtr)sendHandler, &taskParams, &eb);
     // taskHandle = TaskCreate(sendHandler, "sendtask", OS_TASKPRINORM, OS_TASKSTKNORM, s, 0, 0);

      if (taskHandle == NULL)
      {

          UART_printf("main: Failed to create tcpHandler Task\n");
      }
}

/* dtask_tcp_echo() - TCP Echo Server Daemon Function (SOCK_STREAMNC) */
/* (SOCK_STREAMNC, port 7) */
/* Returns "1" if socket 's' is still open, and "0" if its been closed */
//#define RECEIVE_ONLY
//#define SEND_ONLY
#define SEND_RECEIVE
//#define SEND_RECEIVE_SEPARATELY
int dtask_tcp_echo( SOCKET s, uint32_t unused )
{
    struct timeval to;
    int            i;
    char           *pBuf;
    void       *hBuffer;
    int packet_size = 0;
    char                semName[] = "tcptest";

    (void)unused;

    fdOpenSession (TaskSelf ());

    SemaphoreP_Params   semParams;
    SemaphoreP_Params_init (&semParams);
    semParams.mode = SemaphoreP_Mode_BINARY;
    semParams.name = semName;
    semHandle = SemaphoreP_create(1,&semParams);
    //semHandle1 = SemaphoreP_create(1,&semParams);

    /* Configure our socket timeout to be 5 seconds */
    to.tv_sec  = 5;
    to.tv_usec = 0;
    setsockopt( s, SOL_SOCKET, SO_SNDTIMEO, &to, sizeof( to ) );
    setsockopt( s, SOL_SOCKET, SO_RCVTIMEO, &to, sizeof( to ) );

    i = 1;
    setsockopt( s, IPPROTO_TCP, NDK_TCP_NOPUSH, &i, 4 );
    int send_count = 0;
    int recv_count = 0;

#ifdef SEND_ONLY
    for(i = 0; i < BUFFER_SIZE; i++)
        buffer[i] = i;
#endif

#ifdef SEND_RECEIVE_SEPARATELY
    schecule_send(s);
#endif
    for(;;)
    {

#ifdef RECEIVE_ONLY
        i = recv(s, buffer, BUFFER_SIZE, 0);

        UART_printf("\n\rReceived bytes: %d\n", i);
#endif

#ifdef SEND_RECEIVE
       // i = recv(s, buffer, 64*1024*4, 0);

        recv_count = 0;
        while(recv_count < BUFFER_SIZE)
        {
           recv_count += recv(s, buffer+recv_count, BUFFER_SIZE - recv_count, 0);
        }

        UART_printf("\n\rReceived bytes: %d\n", recv_count);



        send_count = 0;

        while(send_count < BUFFER_SIZE)
        {
            send_count += send(s, buffer+send_count, BUFFER_SIZE-send_count, 0 );
        }

        UART_printf("\n\rsent bytes: %d\n", send_count);


#endif
#ifdef SEND_ONLY
        packet_size = BUFFER_SIZE;
        send_count = 0;
        while(send_count < packet_size)
        {
            send_count += send(s, buffer+send_count, packet_size-send_count, 0 );
        }
        UART_printf("\n\rsent bytes: %d\n", send_count);
#endif
#ifdef SEND_RECEIVE_SEPARATELY
        recv_count = 0;

        SemaphoreP_pend(semHandle,BIOS_WAIT_FOREVER);
        while(recv_count < BUFFER_SIZE)
        {
            recv_count += recv(s, buffer+recv_count, BUFFER_SIZE - recv_count, 0);
        }
        SemaphoreP_post(semHandle);
        UART_printf("\n\rReceived bytes: %d\n", recv_count);

       // UART_printf("\n\rReceived bytes: %d\n", recv_count);
     //   SemaphoreP_pend(semHandle,BIOS_WAIT_FOREVER);
      //  memcpy(tx_buffer,buffer,64*1024*4);
      //  SemaphoreP_post(semHandle);

      //  SemaphoreP_post(semHandle1);
      //  Task_sleep(100);

#endif
        //Task_sleep(100);
       // UART_printf("\n\receive thread\n");

     }
    fdCloseSession(TaskSelf());
    fdClose( s );

    /* Return "0" since we closed the socket */
    return(0);
}

