/*
//###########################################################################
//
// FILE:    DSP281x_Headers_nonBIOS.cmd
//
// TITLE:   DSP281x Peripheral registers linker command file 
//
// DESCRIPTION: 
// 
//          This file is for use in Non-BIOS applications.
//
//          Linker command file to place the peripheral structures 
//          used within the DSP28 headerfiles into the correct memory
//          mapped locations.
//
//          This version of the file includes the PieVectorTable structure.
//          For BIOS applications, please use the DSP281x_Headers_BIOS.cmd file
//          which does not include the PieVectorTable structure.
//
//###########################################################################
//
//  Ver | dd mmm yyyy | Who  | Description of changes
// =====|=============|======|===============================================
//      | 05 Mar 2003 | D.A. | Original based on DSP28 v0.58
//  1.00| 11 Sep 2003 | L.H. | Integrated into DSP28 header files
//      |             |      | Added missing eCAN file sections
// -----|-------------|------|-----------------------------------------------
//###########################################################################

//###########################################################################
// Updated: 12.9.05
//###########################################################################
*/

MEMORY
{
 PAGE 0:    /* Program Memory */

   RAMH0_CODE : origin = 0x3F8002, length = 0x0001FE       /* on-chip RAM block H0, first two words of H0 */
                                                           /* are reserved for application's RESET section */

/* sektor C je vyhrazen pro monitor & spol. */
   FLASHC     : origin = 0x3F0000, length = 0x004000       /* on-chip FLASH */

   BEGIN      : origin = 0x3F7FF6, length = 0x000002       /* part of FLASHA; used for "boot to Flash" bootloader mode */
   RESET      : origin = 0x3FFFC0, length = 0x000002

/* sektor J je vyhrazen pro tabulky a jina data */
   FLASHJ     : origin = 0x3D8000, length = 0x002000       /* on-chip FLASH */

 PAGE 1:    /* Data Memory */

   RAMM1      : origin = 0x000400, length = 0x000400       /* on-chip RWM block M1 */
   RAML0      : origin = 0x008000, length = 0x001000
   RAML1      : origin = 0x009000, length = 0x001000
   RAMH0_DATA : origin = 0x3F8200, length = 0x000C00       /* H0 SARAM */
   RAMH0_APP  : origin = 0x3F8E00, length = 0x000EC0       /* H0 SARAM */

   DEV_EMU    : origin = 0x000880, length = 0x000180       /* device emulation registers */
   PIE_VECT   : origin = 0x000D00, length = 0x000100       /* PIE Vector Table */
   FLASH_REGS : origin = 0x000A80, length = 0x000060       /* FLASH registers */
   CSM        : origin = 0x000AE0, length = 0x000010       /* code security module registers */
   XINTF      : origin = 0x000B20, length = 0x000020       /* external interface registers */
   CPU_TIMER0 : origin = 0x000C00, length = 0x000008       /* CPU Timer0 registers (CPU Timer1 and Timer2 are reserved for BIOS)*/
   CPU_TIMER1 : origin = 0x000C08, length = 0x000008       /* CPU Timer1 registers */
   CPU_TIMER2 : origin = 0x000C10, length = 0x000008       /* CPU Timer2 registers */
   PIE_CTRL   : origin = 0x000CE0, length = 0x000020       /* PIE control registers */
   ECANA      : origin = 0x006000, length = 0x000040       /* eCAN control and status registers */
   ECANA_LAM  : origin = 0x006040, length = 0x000040       /* eCAN local acceptance masks */
   ECANA_MOTS : origin = 0x006080, length = 0x000040       /* eCAN message object time stamps */
   ECANA_MOTO : origin = 0x0060C0, length = 0x000040       /* eCAN object time-out registers */
   ECANA_MBOX : origin = 0x006100, length = 0x000100       /* eCAN mailboxes */
   SYSTEM     : origin = 0x007010, length = 0x000020       /* System control registers */
   SPIA       : origin = 0x007040, length = 0x000010       /* SPI registers */
   SCIA       : origin = 0x007050, length = 0x000010       /* SCI-A registers */
   XINTRUPT   : origin = 0x007070, length = 0x000010       /* external interrupt registers */
   GPIOMUX    : origin = 0x0070C0, length = 0x000020       /* GPIO mux registers */
   GPIODAT    : origin = 0x0070E0, length = 0x000020       /* GPIO data registers */
   ADC        : origin = 0x007100, length = 0x000020       /* ADC registers */
   EVA        : origin = 0x007400, length = 0x000040       /* Event Manager A registers */
   EVB        : origin = 0x007500, length = 0x000040       /* Event Manager B registers */
   SCIB       : origin = 0x007750, length = 0x000010       /* SCI-B registers */
   MCBSPA     : origin = 0x007800, length = 0x000040       /* McBSP registers */
   CSM_PWL    : origin = 0x3F7FF8, length = 0x000008       /* Part of FLASHA.  CSM password locations. */
}

SECTIONS
{
/* Setup for "boot to H0" mode: The codestart section (found in DSP28_CodeStartBranch.asm) re-directs execution */
/* to the start of user code. Place this section at the start of H0 */

   codestart         : > BEGIN,       PAGE = 0
   .text             : > FLASHC,      PAGE = 0
   .cinit            : > FLASHC,      PAGE = 0
   .reset            : > RESET,       PAGE = 0, TYPE = DSECT /* not used, */
   .stack            : > RAMM1,       PAGE = 1
   .ebss             : > RAMH0_DATA,  PAGE = 1
   .esysmem          : > RAMH0_DATA,  PAGE = 1

   .econst           : > FLASHC,      PAGE = 0
   .switch           : > FLASHC,      PAGE = 0

   PieVectTableFile  : > PIE_VECT,    PAGE = 1

/*** Peripheral Frame 0 Register Structures ***/
   DevEmuRegsFile    : > DEV_EMU,     PAGE = 1
   FlashRegsFile     : > FLASH_REGS,  PAGE = 1
   CsmRegsFile       : > CSM,         PAGE = 1
   XintfRegsFile     : > XINTF,       PAGE = 1
   CpuTimer0RegsFile : > CPU_TIMER0,  PAGE = 1
   CpuTimer1RegsFile : > CPU_TIMER1,  PAGE = 1
   CpuTimer2RegsFile : > CPU_TIMER2,  PAGE = 1
   PieCtrlRegsFile   : > PIE_CTRL,    PAGE = 1

/*** Peripheral Frame 1 Register Structures ***/
   SysCtrlRegsFile   : > SYSTEM,      PAGE = 1
   SpiaRegsFile      : > SPIA,        PAGE = 1
   SciaRegsFile      : > SCIA,        PAGE = 1
   XIntruptRegsFile  : > XINTRUPT,    PAGE = 1
   GpioMuxRegsFile   : > GPIOMUX,     PAGE = 1
   GpioDataRegsFile  : > GPIODAT      PAGE = 1
   AdcRegsFile       : > ADC,         PAGE = 1
   EvaRegsFile       : > EVA,         PAGE = 1
   EvbRegsFile       : > EVB,         PAGE = 1
   ScibRegsFile      : > SCIB,        PAGE = 1
   McbspaRegsFile    : > MCBSPA,      PAGE = 1

/*** Peripheral Frame 2 Register Structures ***/
   ECanaRegsFile     : > ECANA,       PAGE = 1
   ECanaLAMRegsFile  : > ECANA_LAM    PAGE = 1
   ECanaMboxesFile   : > ECANA_MBOX   PAGE = 1
   ECanaMOTSRegsFile : > ECANA_MOTS   PAGE = 1
   ECanaMOTORegsFile : > ECANA_MOTO   PAGE = 1

/*** Code Security Module Register Structures ***/
   CsmPwlFile        : > CSM_PWL,     PAGE = 1
}

/******************* end of file ************************/

