/**
 * @file NexConfig.h
 *
 * Options for user can be found here. 
 *
 * @author  Wu Pengfei (email:<pengfei.wu@itead.cc>)
 * @date    2015/8/13
 * @copyright 
 * Copyright (C) 2014-2015 ITEAD Intelligent Systems Co., Ltd. \n
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 */
#ifndef __NEXCONFIG_H__
#define __NEXCONFIG_H__

#include <stdint.h>
#include <stdbool.h>
#include <string.h>
#include "inc/hw_types.h"
#include "inc/hw_memmap.h"
#include "inc/hw_uart.h"
#include "driverlib/uart.h"
#include "uartstdio.h"
#include "ustdlib.h"


/**
 * @addtogroup Configuration 
 * @{ 
 */

/**
 * Define DEBUG_SERIAL_ENABLE to enable debug serial.
 * Comment it to disable debug serial.
 */
#define DEBUG_SERIAL_ENABLE


//class dbSerial: public Serial
//{
//public: /* methods */

/**
 * Define dbSerial UART0 for the output of debug messages.
 */
#define dbSerial        Serial

//};

/**
 * Define nexSerial for communicate with Nextion touch panel.
 */
//#define nexSerial    Serial2   //Serial2
#define nexSerial       UART2_BASE


#ifdef DEBUG_SERIAL_ENABLE
#define dbSerialPrint(a)    UARTprintf("%s\r\n",dbSerial.print(a)) //dbSerial.print(a)
#define dbSerialPrintln(a)  UARTprintf("%s\r\n",dbSerial.println(a)) //dbSerial.println(a)
#define dbSerialBegin(a)    UARTprintf("%s\r\n",dbSerial.begin(a)) //dbSerial.begin(a)
#else
#define dbSerialPrint(a)    do{}while(0)
#define dbSerialPrintln(a)  do{}while(0)
#define dbSerialBegin(a)    do{}while(0)
#endif

/**
 * @}
 */

#endif /* #ifndef __NEXCONFIG_H__ */
