/**
 * @file NexObject.cpp
 *
 * The implementation of class NexObject. 
 *
 * @author  Wu Pengfei (email:<pengfei.wu@itead.cc>)
 * @date    2015/8/13
 * @copyright 
 * Copyright (C) 2014-2015 ITEAD Intelligent Systems Co., Ltd. \n
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 */
#include <NexObject.hpp>
#include <stdint.h>
#include <stdbool.h>
#include <string.h>
#include <stdarg.h>
#include "uartstdio.h"
#include "ustdlib.h"

NexObject::NexObject(uint8_t pid, uint8_t cid, const char *name)
{
    this->__pid = pid;
    this->__cid = cid;
    this->__name = name;
}

uint8_t NexObject::getObjPid(void)
{
    return __pid;
}

uint8_t NexObject::getObjCid(void)
{
    return __cid;
}

const char* NexObject::getObjName(void)
{
    return __name;
}

void NexObject::printObjInfo(void)
{
    UARTprintf("[ %i");
    //dbSerialPrint("[");
    UARTprintf("%i", (uint32_t)this);
    //dbSerialPrint((uint32_t)this);
    UARTprintf(": %i");
    //dbSerialPrint(":");
    UARTprintf("__pid %i");
    //dbSerialPrint(__pid);
    UARTprintf(", %i");
    //dbSerialPrint(",");
    UARTprintf("__cid %i");
    // dbSerialPrint(__cid);
    UARTprintf(", %i");
    //dbSerialPrint(",");
    if (__name)
    {
        UARTprintf("_name %i");
        //dbSerialPrint(__name);
    }
    else
    {
        UARTprintf("(null) %i");
        //dbSerialPrint("(null)");
    }
    UARTprintf("] %i\r\n");
    //dbSerialPrintln("]");
}

