/*
 * nextion_ctrl.c
 *
 *  Created on: Aug 31, 2019
 *      Author: Brett
 */
#include <NexObject.hpp>
#include <NexTouch.hpp>
#include <stdint.h>
#include <stdbool.h>
#include <string.h>
#include <stdarg.h>

#include "inc/hw_SysCtl.h"
#include "inc/hw_types.h"
#include "inc/hw_memmap.h"
#include "inc/hw_uart.h"
#include "inc/hw_ints.h"
#include "driverlib/SysCtl.h"
#include "driverlib/rom.h"
#include "driverlib/rom_map.h"
#include "driverlib/uart.h"
#include "uartstdio.h"
#include "ustdlib.h"
#include "qs_iot.h"
//#include "ringbuf.h"
#include "NexConfig.h"

#define NEX_RET_CMD_FINISHED            (0x01)
#define NEX_RET_EVENT_LAUNCHED          (0x88)
#define NEX_RET_EVENT_UPGRADED          (0x89)
#define NEX_RET_EVENT_TOUCH_HEAD            (0x65)
#define NEX_RET_EVENT_POSITION_HEAD         (0x67)
#define NEX_RET_EVENT_SLEEP_POSITION_HEAD   (0x68)
#define NEX_RET_CURRENT_PAGE_ID_HEAD        (0x66)
#define NEX_RET_STRING_HEAD                 (0x70)
#define NEX_RET_NUMBER_HEAD                 (0x71)
#define NEX_RET_INVALID_CMD             (0x00)
#define NEX_RET_INVALID_COMPONENT_ID    (0x02)
#define NEX_RET_INVALID_PAGE_ID         (0x03)
#define NEX_RET_INVALID_PICTURE_ID      (0x04)
#define NEX_RET_INVALID_FONT_ID         (0x05)
#define NEX_RET_INVALID_BAUD            (0x11)
#define NEX_RET_INVALID_VARIABLE        (0x1A)
#define NEX_RET_INVALID_OPERATION       (0x1B)

//uint32_t Serial0;
//uint32_t Serial2;


/******************************************************/
//!
//! Initialize Nextion TXD/RXD lines via UART2
//!
/******************************************************/
void
NexInit(void)
{

    static uint8_t cmd1[1] = {0xFF};
    static uint8_t cmd2[1] = {0xFF};
    static uint8_t cmd3[1] = {0xFF};

    /* Disable UART2 prior to configuration */
    MAP_UARTDisable(UART2_BASE);

    /* Configure UART2 for Nextion LCD control functions. */
    MAP_UARTConfigSetExpClk(UART2_BASE, g_ui32SysClock, 115200,
                            (UART_CONFIG_PAR_NONE | UART_CONFIG_STOP_ONE |
                             UART_CONFIG_WLEN_8));

    /* Make the system clock source */
    MAP_UARTClockSourceSet(UART2_BASE, UART_CLOCK_SYSTEM);

    /* Set the UART to interrupt whenever the TX/RX FIFO
     * is almost empty or when any character is received. */
    MAP_UARTFIFOLevelSet(UART2_BASE, UART_FIFO_TX1_8, UART_FIFO_RX1_8);
    /* Set the FIFO mode TX/Rx level triggered interrupts */
    MAP_UARTTxIntModeSet(UART2_BASE, UART_TXINT_MODE_FIFO);

    /* Enable the TXD/RXD interrupts for data transfer handlers  */
    MAP_UARTIntEnable(UART2_BASE, (UART_INT_RX | UART_INT_TX | UART_INT_CTS));
    /* Enable UART2 with FIFO for polling test */
    MAP_UARTEnable(UART2_BASE);
    MAP_UARTFIFOEnable(UART2_BASE);
    MAP_IntEnable(INT_UART2);

    /* Send Reset command Nextion LCD screen */
    UARTCharPut(UART2_BASE, 'r');
    UARTCharPut(UART2_BASE, 'e');
    UARTCharPut(UART2_BASE, 's');
    UARTCharPut(UART2_BASE, 't');
    UARTCharPut(UART2_BASE, cmd1[0]);
    UARTCharPut(UART2_BASE, cmd2[0]);
    UARTCharPut(UART2_BASE, cmd3[0]);

}

/******************************************************/
//!
//! Configure the Nextion Transmit UART2 controls
//!
/******************************************************/
void
NexTXD(uint32_t cVar, uint8_t cData, uint32_t timeout )
{

    /* Temporary buffers for variables/data */
    uint8_t cVarBuff[1];
    uint8_t cDataBuff[1];

    /* Flush the TX/RX buffers */
    //UARTFlushTx(true);
    //UARTFlushRx(true);
    //
     cVarBuff[0] = cVar;
     cDataBuff[0] = cData;

    //
    // Write the same character using the NON-blocking write function.  This
    // function will return if there was space in the FIFO and the character is written.
    // This function does not block, so if there is no space available, then a
    //! \b false is returned and the application must retry the function later.
    //! \return Returns \b true if the character was successfully placed in the
    //! transmit FIFO or \b false if there was no space available in the transmit FIFO.
    //
    if(UARTSpaceAvail(UART2_BASE))
    {
        // Put a character to show INT example.
        // This will display on the terminal
        //
        UARTCharPut(UART2_BASE, cVarBuff[0] | cDataBuff[0]);

        //UARTCharPut(UART2_BASE, cThisChar);
    }


}

/******************************************************
*
* Configure Nextion UART2 (RXD) CallBack numbers
* Receive string data.
* Receive string data.
*
* @param buffer - save string data.
* @param len - string buffer length.
* @param timeout - set timeout time.
*
* @return the length of string buffer.
*
******************************************************/
uint16_t
NexRXD(char *buffer, uint16_t len, uint32_t timeout)
{

    /* Char Buffer array */
    //static uint8_t NexChar;
    char temp[3]; //= {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15};
    bool ret = false;
    bool str_start_flag = false;
    static uint32_t Timeout;
    uint8_t cnt_0xff = 0;
    static uint8_t c;


    Timeout = timeout;

    if (!buffer || len == 0)
     {
         goto __return;
     }

    //
    // Enter a loop to read characters from the UART, and write them back
    // (echo).  When a line end is received, the loop terminates.
    //
    // Read a character using the non-blocking read function.  This
    // function will return -1 if a character is not available.
    //
    //
    /* Timeout for getting RXD FIFO bytes */
    for(Timeout = 0; Timeout < timeout; Timeout--)
    {

        //& 0xFF == UARTCharGet(UART2_BASE)) //NonBlocking ((uint8_t *)cChar, sizeof(cChar))
        {
        //UARTprintf("Code:-> %i\r\n", &cChar);

        }
        /* Check for the variable callback name */
        {
        /* Move pointer to next character */
        // cChar[2,3,4,5,6,7,8,9,10,11] = UARTCharGet(UART2_BASE)& 0xFF;
        // UARTprintf("Radix: %i\r\n", &cChar);
        }

        while (Timeout <= timeout)
        {
            while (UARTCharsAvail(UART2_BASE))
            {
               c =  UARTCharGet(UART2_BASE)&0xFF;
               if (str_start_flag)
               {
                   if (0xFF == c)
                   {
                       cnt_0xff++;
                       if (cnt_0xff >= 3)
                       {
                           break;
                       }
                   }
                   else
                   {
                       temp[2] += c;//(char)
                   }
               }
               else if (NEX_RET_STRING_HEAD == c)
               {
                   str_start_flag = true;
               }
            }

            if (cnt_0xff >= 3)
            {
               break;
            }

            ret = strlen(temp); //temp.strlen()
            ret = ret > len ? len : ret;
            strncpy(buffer, strdup(temp), ret); //temp.c_str()

        }
    }

__return:

    return (ret);
}

/**
 * Listen touch event and calling callbacks attached before.
 *
 * Supports push and pop at present.
 *
 * @param nex_listen_list - index to Nextion Components list.
 * @return none.
 *
 * @warning This function must be called repeatedly to response touch events
 *  from Nextion touch panel. Actually, you should place it in your loop function.
 */
void
nexLoop(NexTouch *nex_listen_list[])
{
    static uint8_t __buffer[10];

    uint16_t i;
    uint8_t c;

    while (UARTCharsAvail(UART2_BASE) > 0)
    {
        /* Delay 5ms in this loop cycle */
        SysCtlDelay(SYSTEM_CLOCK / 200);

        c = UARTCharGet(UART2_BASE)&0xFF;

        if (NEX_RET_EVENT_TOUCH_HEAD == c)
        {
            if (UARTCharsAvail(UART2_BASE) >= 6)
            {
                __buffer[0] = c;
                for (i = 1; i < 7; i++)
                {
                    __buffer[i] = UARTCharGet(UART2_BASE)&0xFF;
                }
                __buffer[i] = 0x00;

                if (0xFF == __buffer[4] && 0xFF == __buffer[5] && 0xFF == __buffer[6])
                {
                    NexTouch:: iterate(nex_listen_list, __buffer[1], __buffer[2], (int32_t)__buffer[3]);
                }

            }
        }
    }
}


/*********************************************************/
//!
//! Nextion Control UART2 TX/RX interrupt handler
//! This funciton checks the MIS bits to determine the
//! interrutp souurce from the endabled IS flags.
//!
/*********************************************************/
void
NexUartIntHandler(void)
{
    uint32_t ui32IntStatus = 0;
    uint32_t ui32RxErrorStatus = 0;
    //static uint32_t cChar;

    /* Get the UARTMIS status bits, false get RAW bits */
    ui32IntStatus = UARTIntStatus(UART2_BASE, true);


    if (ui32IntStatus & (UART_INT_TX | UART_INT_CTS))
    {
        /* Clear any UARTICR bits set by UARTIntEnable() */
        UARTIntClear(UART2_BASE, ui32IntStatus);
        //NexTXD(0,0,0);
    }

    if (ui32IntStatus & UART_INT_RX)
    {
        /* Clear any UARTICR bits set by UARTIntEnable() */
        UARTIntClear(UART2_BASE, ui32IntStatus);

        /* Check the ECR register for
         * RX errors: OE, BE, PE, FE  */
        if(ui32RxErrorStatus == UARTRxErrorGet(UART2_BASE))
        {
            /* Clear all CER error bits and return */
            UARTRxErrorClear(UART2_BASE);
            /* Debug hex print each status result */
            ui32RxErrorStatus &= (UART_INT_OE|UART_INT_BE|UART_INT_PE|UART_INT_FE);
            UARTprintf("RxEror: %x\r\n", ui32RxErrorStatus);

            return;
        }

        /* Call handler to process PID, CID, Name or return caller */
        NexRXD(0, 10, 100);

    }
}

