/*
 * nextion_ctrl.h
 *
 *  Created on: Aug 31, 2019
 *      Author: Brett
 */

#ifndef NEXTION_CTRL_H_
#define NEXTION_CTRL_H_

#include <NexTouch.hpp>
#include "NexConfig.h"

/**
 * Listen touch event and calling callbacks attached before.
 *
 * Supports push and pop at present.
 *
 * @param nex_listen_list - index to Nextion Components list.
 * @return none.
 *
 * @warning This function must be called repeatedly to response touch events
 *  from Nextion touch panel. Actually, you should place it in your loop function.
 */
extern void nexLoop(NexTouch *nex_listen_list[]);

extern void NexInit(void);
extern void NexTXD(uint32_t cVar, uint8_t cData, uint32_t timeout);
extern uint16_t NexRXD(char *buffer, uint16_t len, uint32_t timeout);
extern void NexUartIntHandler(void);



#endif /* NEXTION_CTRL_H_ */
