//###########################################################################
//
//
// FILE:		ADC_EXAMPLE_1.c
//
// TITLE:		Generate a PWM signal with constant switching frequency and variable duty.
//	                The switching frequency of the signal generated at EPWM - 1A is 50 kHz
//  		and Duty of the signal should be varied between 10% to 90% of the total switching
//		period based on the input from the ADC. Ensure a constant switching frequency
//		of 50 kHz.
//###########################################################################

#include "DSP2833x_Device.h"
#include "PeripheralHeaderIncludes.h"
//#include "HVPM_Sensorless-Settings.h"
#include "IQmathLib.h"
#include "HVPM_Sensorless.h"
#include <math.h>

// external function prototypes

extern void InitSysCtrl(void);
extern void InitAdc(void);
extern void InitPieCtrl(void);
extern void InitPieVectTable(void);

// Prototype statements for functions found within this file.

void Gpio_select(void);                                     // GPIO function declared in global
void Setup_adc(void);
interrupt void adc_isr(void);                              // ADC  End of Sequence ISR
void Setup_ePWM(void);


PI_CONTROLLER pi1 = PI_CONTROLLER_DEFAULTS;
// Global Variables
unsigned int ADC1;                                         // Variable to store ADC value
float input1=1.5;
float input2;
float output1;
//PI   pi1=PI_DEFAULTS;

void main(void)
{
    InitSysCtrl();                                          // Basic Core Init from DSP2833x_SysCtrl.c

    DINT;                                                     // Disable all interrupts

    InitPieCtrl();                                          // basic setup of PIE table; from DSP2833x_PieCtrl.c

    InitPieVectTable();                                     // default ISR's in PIE

    Gpio_select();

    Setup_ePWM();                                       // init of ePWM1A

    InitAdc();                                          // Basic ADC setup, incl. calibration

    Setup_adc();

    //----------------------------------------------------------------------------------------------//
    // PI Controller Values//

    pi1.Kp = _IQ(0.5);   // Pass _iq parameters to pi1
    pi1.Ki  = _IQ(0.001);   // Pass _iq parameters to pi1
    pi1.Umax =_IQ(0.9);  // Pass _iq parameters to pi1
    pi1.Umin  =_IQ(-0.9);  // Pass _iq parameters to pi1

    //----------------------------------------------------------------------------------------------//





    PieCtrlRegs.PIEIER1.bit.INTx6 = 1;                  //  interput enable. interupt for adc at 1.6 ADC

    EALLOW;
    PieVectTable.ADCINT = &adc_isr;                     // service routine it has to perform
    EDIS;

    IER =0x0001;                                       // enabling interupt line 1
    EINT;
    ERTM;


}

// GPIO Initialisation
void Gpio_select(void)
{
    EALLOW;
    GpioCtrlRegs.GPAMUX1.all = 0;                           // GPIO15 ... GPIO0 = General Puropse I/O
    GpioCtrlRegs.GPAMUX1.bit.GPIO0= 1;                     // ePWM1A active

    GpioCtrlRegs.GPAMUX2.all = 0;       // GPIO31 ... GPIO16 = General Purpose I/O
    GpioCtrlRegs.GPBMUX1.all = 0;       // GPIO47 ... GPIO32 = General Purpose I/O
    GpioCtrlRegs.GPBMUX2.all = 0;       // GPIO63 ... GPIO48 = General Purpose I/O
    GpioCtrlRegs.GPCMUX1.all = 0;       // GPIO79 ... GPIO64 = General Purpose I/O
    GpioCtrlRegs.GPCMUX2.all = 0;       // GPIO87 ... GPIO80 = General Purpose I/O

    GpioCtrlRegs.GPADIR.all = 0;
    GpioCtrlRegs.GPBDIR.all = 0;        // GPIO63-32 as inputs
    GpioCtrlRegs.GPCDIR.all = 0;        // GPIO87-64 as inputs
    EDIS;
}

// ADC Initialisation - Start of Conversion by EPWM
void Setup_adc(void)
{

    AdcRegs.ADCTRL1.all = 0;                 // to avoid garbage value
    AdcRegs.ADCTRL1.bit.ACQ_PS = 7;      // 7 = 8 x ADCCLK time period define the length of sample window
    AdcRegs.ADCTRL1.bit.SEQ_CASC =1;     // 1=cascaded sequencer It defines the Sequencer Mode to be a state machine with 16 states (SEQCASC = 1), or to operate as two independent state machines, each having 8 states (SEQ_CASC = 0).
    AdcRegs.ADCTRL1.bit.CPS = 0;         // divide by 1 // is used to divide the input frequency by 1 or 2.
    AdcRegs.ADCTRL1.bit.CONT_RUN = 0;    // continuous run mode // defines whether the auto sequencer starts at the end of a sequence (=0) and waits for another trigger or if the sequence should start all over again immediately

    AdcRegs.ADCTRL2.all = 0;                 // to avoid garbage value
    AdcRegs.ADCTRL2.bit.SOC_SEQ1 = 0;    //  1=software trigger-start SEQ1, 0=clear pending SOC trigger // resetting trigger
    AdcRegs.ADCTRL2.bit.INT_ENA_SEQ1 = 1;    // 1=enable SEQ1 interrupt //
    AdcRegs.ADCTRL2.bit.INT_MOD_SEQ1 = 0;    // 0= interrupt after every end of sequence (INT_MOD_SEQ1) define the interrupt mode of SEQ1. We can specify whether we have an interrupt request every End of Sequence (EOS) or every other (EOS).

    // Reading Interrupt from EPWM1       - Instruction for SOC interrupt from EPWM
    AdcRegs.ADCTRL2.bit.EPWM_SOCA_SEQ1 = 1;  // 0=cannot be started by ePWM trigger
                         // 1=can be started by ePWM trigger

    AdcRegs.ADCTRL3.bit.ADCCLKPS = 3;    // ADC clock: FCLK = HSPCLK / 2 * ADCCLKPS
                         // HSPCLK = 75MHz (see DSP2833x_SysCtrl.c)
                         // FCLK = 12.5 MHz

    AdcRegs.ADCMAXCONV.all = 0x00F;     // 2 conversions from Sequencer 1

    AdcRegs.ADCCHSELSEQ1.bit.CONV00 = 0x3;     // Setup ADCINA0 as 1st SEQ1 conv. channel selecte sequence from auto sequencer
  //  AdcRegs.ADCCHSELSEQ1.bit.CONV01 = 1;     // Setup ADCINA1 as 2nd SEQ1 conv.


}

void Setup_ePWM(void)
{
    EPwm1Regs.TBCTL.bit.CLKDIV =  1;    // CLKDIV = 1
    EPwm1Regs.TBCTL.bit.HSPCLKDIV = 1;  // HSPCLKDIV = 2
    EPwm1Regs.TBCTL.bit.CTRMODE = 2;    // up - down mode
    EPwm1Regs.AQCTLA.all = 0x0060;      // set ePWM1A on CMPA up
                                        // clear ePWM1A on CMPA down
    EPwm1Regs.TBPRD = 375;                // 50 KHz - PWM signal
    EPwm1Regs.CMPA.half.CMPA  = 37.5;    // initial cmpa set at 10 % of time period

            // generating interrupt to ADC SOC
    EPwm1Regs.ETSEL.bit.SOCAEN = 1;     // enable SOC of EPWM1SOCA 1=Enable EPWM1SOCA pulse, 0=Disable EPWMxSOCA pulse
    EPwm1Regs.ETSEL.bit.SOCASEL = 1;    // selection option of SOC, 1 = Enable event time-base counter equal to zero
    EPwm1Regs.ETPS.bit.SOCAPRD = 1;     // EPWM1SOCB/A Period 0=disable, 1=SOC on first event, 2=SOC on second event, 3=SOC on third event
    EPwm1Regs.ETPS.bit.SOCACNT = 3;     // EPWM1SOCB/A Counter 0 = no events, 1 = 1event, 2 = 2event, 3 = 3event. doubt

}

interrupt void  adc_isr(void)
{
    ADC1 = AdcMirror.ADCRESULT0;            // store ADC value
    input2 = (AdcRegs.ADCRESULT0)*3.0/65520;//pin A0

    //compensator();

    EPwm1Regs.CMPA.half.CMPA  =EPwm1Regs.TBPRD * pi1.Out  ; // Duty changed between 10 % to 90 % of TBPRD
    // Reinitialize for next ADC sequence
    AdcRegs.ADCTRL2.bit.RST_SEQ1 = 1;       // Reset SEQ1
    AdcRegs.ADCST.bit.INT_SEQ1_CLR = 1;     // Clear INT SEQ1 bit;


    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1; // Acknowledge interrupt to PIE
}
void interrupt periodic_interrupt_isr()
{
	pi1.Ref = input1;   // Pass _iq inputs to pi1
	pi1.Fbk = input2;   // Pass _iq inputs to pi1


	PI_MACRO(pi1);  // Call compute macro for pi1

	 output1 = pi1.Out;  // Access the output of pi1

}



