// MyFFT.h (Created by FFTDesigner - Version 3.70)

/******************************************************************************

COPYRIGHT.  This software is Copyright  2011 RHDC Services Ltd.

        !  DO NOT EDIT THIS FILE AS IT MAY BE OVERWRITTEN BY
        THE DESIGNER RESULTING IN YOUR CHANGES BEING LOST  !

DISTRIBUTION.  This software may NOT be distributed to a third party without
prior written approval of the copyright holder. Please see the FFT Designer
End User Licence Agreement for details about distribution in object-code form.

DISCLAIMER.  This software is provided "AS IS", without express or implied
warranty.  In no event shall the copyright holder, author(s) or provider(s)
of this software be held liable for any damages arising from its use.

        FFTLength ................................ 8
        WindowType ............................... Kaiser
        WindowLoss (dB) .......................... 8.27
        Equivalent Noise Bandwidth ENBW (Bins) ... 2.052
        Incoherent Power Gain .................... 0.3056
        Coherent Power Gain ...................... 0.1489
        WindowAlpha .............................. 3
        Language ................................. MSP430 Extended C
        Algorithm ................................ Integer (16 Bit)
        Use Shift Division ....................... True
        Use Direct MPY32 Access .................. True

NOTE. When option "Use Direct MPY32 Access" is True, this software will make
direct use of the MPY32 hardware multiplier module including its configuration
registers as well as the operand and result registers.  Therefore, if any ISR
needs to be active whilst the FFT methods are in use, they must comply with
either (a) or (b) below.

   (a). They must not use the MPY32 hardware multiplier module.
   (b). They must perform a full MPY32 context save and restore.

Refer to section "32-Bit Hardware Multiplier", sub-section "Using Interrupts"
of the MSP430x5xx User Guide for more details.

******************************************************************************/

#include "MyFFT_Tables.h"
#include "MyFFT_Include.h"

#define MyFFT_INPUT_LENGTH	8
#define MyFFT_LOG2BASE2OFN	3
#define MyFFT_WINDOW_LOSS_DB	8.27
#define MyFFT_WINDOW_ENBW_BINS	2.052
#define MyFFT_WINDOW_INCOHERENT_POWER_GAIN	0.3056
#define MyFFT_WINDOW_COHERENT_POWER_GAIN	0.1489

extern MyFFT_Workspace_t MyFFT_ResultR[];
extern MyFFT_Workspace_t MyFFT_ResultI[];

void MyFFT_Sample(MyFFT_Workspace_t * input_buffer);
void MyFFT_Window(void);
void MyFFT_Reorder(void);
void MyFFT_Transform(void);
void MyFFT_CalculateDft(MyFFT_Workspace_t * input_buffer);
void MyFFT_Init(MyFFT_Workspace_t * input_buffer_start, int input_buffer_length);
