
#include "bl_Controller.h"
#include <hw_gpio.h>
#include <hw_nvic.h>

#pragma SET_CODE_SECTION(".bl_text")

//************************************************************************************************
Tbl_Controller::Tbl_Controller(Tbl_Hw& aHW) :
    HW(aHW)
{
    Tbl_I2CDriver I2CDriver(HW);
    //Nun noch fr zwei Sekunden auf ein Kabelupdate warten
    uint32_t StartTick = HW.actTickValue();
    do
    {
        //I2CDriver.checkForInterrupts();
        if (false) //I2CDriver.newFrameReceived)
        {
            if (false) //checkReceivedI2CData(I2CDriver));
                StartTick -= HW.TickToMs(5000);  //Das beendet die while Schleife
        }
    }
    while (HW.delta_ms(StartTick)<2000);
    //Alle Interrupts deaktivieren
    HWREG(NVIC_DIS0) = 0xFFFFFFFF;
    HWREG(NVIC_DIS1) = 0x3F;  //Es gibt nur Interrupts auf den unteren 6 Bits
    //Eventuelle Interrupt Pending Bits lschen
    HWREG(NVIC_UNPEND0) = 0xFFFFFFFF;
    HWREG(NVIC_UNPEND0) = 0x3F;  //Es gibt nur Interrupts auf den unteren 6 Bits

    HW.SignalPoint(1);
    I2CDriver.Cleanup();
    HW.SignalPoint(2);
}

//************************************************************************************************
Tbl_Controller::~Tbl_Controller()
{
}

//************************************************************************************************
//true: nicht weiter auf Daten warten
bool Tbl_Controller::checkReceivedI2CData(Tbl_I2CDriver& I2CDriver)
{
    if (I2CDriver.nBytesReceived == 1)
    {
        if (I2CDriver.ReceivedBytes[0] == 67)   //67 ist das Zeichen 'C'
        {
            return true;
        }
    }
    return false;
}

//************************************************************************************************
void Tbl_Controller::sendDeviceDetails(Tbl_I2CDriver& I2CDriver)
{
}




#pragma SET_CODE_SECTION()

