
#ifndef BL_CONTROLLER_H_
#define BL_CONTROLLER_H_

#include "bl_Hw.h"
#include "bl_I2CDriver.h"

#define BLC_FRAME_SIZE 532

class Tbl_Controller
{
public:
    Tbl_Controller(Tbl_Hw& aHW);
    ~Tbl_Controller();

private:

    enum eFrameReceiveState
    {
        eWaitForLength1,
        eWaitForLength2,
        eWaitForByte
    };
    bool checkReceivedI2CData(Tbl_I2CDriver& I2CDriver);
    void sendDeviceDetails(Tbl_I2CDriver& I2CDriver);

    Tbl_Hw& HW;

    uint8_t  mFrameBuffer[BLC_FRAME_SIZE];
    uint32_t mnByteLeftInFrame;
    uint32_t mFrameBufferIndex;
    eFrameReceiveState mFrameReceiveState;
    uint32_t mReceivedValue;
};

#endif /* BL_CONTROLLER_H_ */
