
#ifndef BL_I2CDRIVER_H_
#define BL_I2CDRIVER_H_

#include "bl_Hw.h"

class Tbl_I2CDriver
{
public:
    Tbl_I2CDriver(Tbl_Hw& aHw);
    ~Tbl_I2CDriver();
    void Cleanup();

    static const uint32_t MaxRxBytes = 200;
    static const uint32_t MaxTxBytes = 20;

    void checkForInterrupts();
    uint8_t ReceivedBytes[MaxRxBytes];
    uint32_t nBytesReceived;
    bool newFrameReceived;

    uint8_t ToTransmitBytes[MaxTxBytes];
    uint32_t nBytesToTransmit;
    uint32_t nBytesAlreadyTransmitted;
    bool allBytesTransmitted;
private:
    Tbl_Hw& Hw;
};

#endif /* BL_I2CDRIVER_H_ */
