
#include <stdint.h>
#include <hw_types.h>
#include <hw_cpu_scs.h>
#include <hw_memmap.h>
#include <hw_gpio.h>

//Wir benutzen das TI-RTOS aus dem ROM. Dort sind keine Task-Hooks untersttzt.
int nExceptionsX = 0;

void myExceptionHandler(uint32_t* pExcStack, uint32_t lr);
void myIdleFunction();



void myExceptionHandler(uint32_t* pExcStack, uint32_t lr)
{
    uint32_t RegValue = HWREG(CPU_SCS_BASE + CPU_SCS_O_CFSR);
    if (RegValue & CPU_SCS_CFSR_DIVBYZERO)
    {
        //Durch 0 geteilt
        nExceptionsX = 1;
    }
    else if (RegValue & CPU_SCS_CFSR_UNALIGNED)
    {
        //Speicherzugriff war nicht korrekt aligned
        nExceptionsX = 2;
    }
    else if (RegValue & CPU_SCS_CFSR_NOCP)
    {
        //Eine Co-Prozessor Instruktion sollte ausgefhrt werden
        nExceptionsX = 3;
    }
    else if (RegValue & CPU_SCS_CFSR_INVPC)
    {
        //Ungltiges EXC_RETURN Kommando
        nExceptionsX = 4;
    }
    else if (RegValue & CPU_SCS_CFSR_INVSTATE)
    {
        //Kommando bei ungltigem EPSR Zustand
        nExceptionsX = 5;
    }
    else if (RegValue & CPU_SCS_CFSR_UNDEFINSTR)
    {
        //Unbekanntes Kommando
        nExceptionsX = 6;
    }
    else if (RegValue & CPU_SCS_CFSR_BFARVALID)
    {
        //Das Bus Fault Address Register enthlt einen gltigen Wert.
        //Den msste man also auslesen knnen
        nExceptionsX = 7;
    }
    else if (RegValue & CPU_SCS_CFSR_STKERR)
    {
        //Abarbeiten des Stacks bei einer Exception fhrte zu einem Bus Fault
        nExceptionsX = 8;
    }
    else if (RegValue & CPU_SCS_CFSR_UNSTKERR)
    {
        //"Unstacking" des Stacks bei einer Exception fhrte zu einem Bus Fault
        nExceptionsX = 9;
    }
    else if (RegValue & CPU_SCS_CFSR_IMPRECISERR)
    {
        //Ungenauer Bus Fault
        nExceptionsX = 10;
    }
    else if (RegValue & CPU_SCS_CFSR_PRECISERR)
    {
        //Precise data bus error return???
        nExceptionsX = 11;
    }
    else if (RegValue & CPU_SCS_CFSR_IBUSERR)
    {
        //Fehler beim prefetch eines Kommandos
        nExceptionsX = 12;
    }
    else if (RegValue & CPU_SCS_CFSR_MMARVALID)
    {
        //Memory Manage Address Register ist gltig. Warum ist das eine Exception?
        //Oder doch nur zustzliche Information und es ist noch was anderes Zustzlich gesetzt
        nExceptionsX = 13;
    }
    else if (RegValue & CPU_SCS_CFSR_MSTKERR)
    {
        //Abarbeiten des Stacks bei einer Exception fhrte zu einem Access Violation
        nExceptionsX = 14;
    }
    else if (RegValue & CPU_SCS_CFSR_MUNSTKERR)
    {
        //"Unstacking" des Stacks bei einer Exception fhrte zu einem Access Violation
        nExceptionsX = 15;
    }
    else if (RegValue & CPU_SCS_CFSR_DACCVIOL)
    {
        //Data Access Violation. Die Adresse ist bei dem Kommando nicht erlaubt
        nExceptionsX = 16;
    }
    else if (RegValue & CPU_SCS_CFSR_IACCVIOL)
    {
        //Instuction Access Violation. Versuch ein Kommando von einer Adresse zu holen, die nicht erlaubt ist
        nExceptionsX = 17;
    }

    while (true)
    {
    }
}

void myIdleFunction()
{
    while (1) {}
}
