/*
 * main.c
 */
enum ErrorsBitposition_E
{
   S1_TopErrBP = 0,
   S1_BotErrBP,
   S1_TempErrBP,
   S1_ConnErrBP,
   S2_TopErrBP,
   S2_BotErrBP,
   S2_TempErrBP,
   S2_ConnErrBP,
   S3_TopErrBP,
   S3_BotErrBP,
   S3_TempErrBP,
   S3_ConnErrBP,
   S4_TopErrBP,
   S4_BotErrBP,
   S4_TempErrBP,
   S4_ConnErrBP,
   I1_OverCurrentBP,
   I2_OverCurrentBP,
   I3_OverCurrentBP,
   I4_OverCurrentBP,
   U1_OverVoltageBP,
   U2_OverVoltageBP,
   U3_OverVoltageBP,
   U4_OverVoltageBP,
   S1_ISRCalcTimeTooLongBP,
   S2_ISRCalcTimeTooLongBP,
   S3_ISRCalcTimeTooLongBP,
   S4_ISRCalcTimeTooLongBP,
   PPW_DisabledBP,
   APACU_DisabledBP,
   DisabledByDebuggerStopBP,
   DisabledBySoftwareBP,
   ReservedBP
};

//! All possible errors. This enum is bitcoded. Line 0 is bit0, line 1 is bit1, and so on. (except NO_Error).\n
//! More than one error can occur at the same time, so more than one bit can be set.
typedef enum
{
   //! No error occured.
   NO_Error = 0,
   //! S1 PWM lock due to top error.
   S1_TopErr = (1UL << S1_TopErrBP),
   //! S1 PWM lock due to bot error.
   S1_BotErr = (1UL << S1_BotErrBP),
   //! S1 PWM lock due to temperature error.
   S1_TempErr = (1UL << S1_TempErrBP),
   //! S1 PWM lock due to connector error.
   S1_ConnErr = (1UL << S1_ConnErrBP),
   //! S2 PWM lock due to top error.
   S2_TopErr = (1UL << S2_TopErrBP),
   //! S2 PWM lock due to bot error.
   S2_BotErr = (1UL << S2_BotErrBP),
   //! S2 PWM lock due to temperature error.
   S2_TempErr = (1UL << S2_TempErrBP),
   //! S2 PWM lock due to connector error.
   S2_ConnErr = (1UL << S2_ConnErrBP),
   //! S3 PWM lock due to top error.
   S3_TopErr = (1UL << S3_TopErrBP),
   //! S3 PWM lock due to bot error.
   S3_BotErr = (1UL << S3_BotErrBP),
   //! S3 PWM lock due to temperature error.
   S3_TempErr = (1UL << S3_TempErrBP),
   //! S3 PWM lock due to connector error.
   S3_ConnErr = (1UL << S3_ConnErrBP),
   //! S4 PWM lock due to top error.
   S4_TopErr = (1UL << S4_TopErrBP),
   //! S3 PWM lock due to bot error.
   S4_BotErr = (1UL << S4_BotErrBP),
   //! S4 PWM lock due to temperature error.
   S4_TempErr = (1UL << S4_TempErrBP),
   //! S4 PWM lock due to connector error.
   S4_ConnErr = (1UL << S4_ConnErrBP),
   //! S1 PWM lock due to overcurrent error.
   I1_OverCurrent = (1UL << I1_OverCurrentBP),
   //! S2 PWM lock due to overcurrent error.
   I2_OverCurrent = (1UL << I2_OverCurrentBP),
   //! S3 PWM lock due to overcurrent error.
   I3_OverCurrent = (1UL << I3_OverCurrentBP),
   //! S4 PWM lock due to overcurrent error.
   I4_OverCurrent = (1UL << I4_OverCurrentBP),
   //! S1 PWM lock due to overvoltage error.
   U1_OverVoltage = (1UL << U1_OverVoltageBP),
   //! S2 PWM lock due to overvoltage error.
   U2_OverVoltage = (1UL << U2_OverVoltageBP),
   //! S3 PWM lock due to overvoltage error.
   U3_OverVoltage = (1UL << U3_OverVoltageBP),
   //! S4 PWM lock due to overvoltage error.
   U4_OverVoltage = (1UL << U4_OverVoltageBP),
   //! S1 PWM lock due to ISR calculation time too long.
   S1_ISRCalcTimeTooLong = (1UL << S1_ISRCalcTimeTooLongBP),
   //! S2 PWM lock due to ISR calculation time too long.
   S2_ISRCalcTimeTooLong = (1UL << S2_ISRCalcTimeTooLongBP),
   //! S3 PWM lock due to ISR calculation time too long.
   S3_ISRCalcTimeTooLong = (1UL << S3_ISRCalcTimeTooLongBP),
   //! S4 PWM lock due to ISR calculation time too long.
   S4_ISRCalcTimeTooLong = (1UL << S4_ISRCalcTimeTooLongBP),
   //! Is set if PulsPausenWerk in FPGA is disabled. Can be enabled by calling EnablePPW().
   PPW_Disabled = (1UL << PPW_DisabledBP),
   //! Is set if APACU is disabled. APACU can be enabled by putting external pin X100.1 to high (24V).
   APACU_Disabled = (1UL << APACU_DisabledBP),
   //! Is set if the debugger stops the CPU.
   DisabledByDebuggerStop = (1UL << DisabledByDebuggerStopBP),
   //! Is set if function DisablePWM() is called.
   DisabledBySoftware = (1UL << DisabledBySoftwareBP),
   //! Reserved for future use.
   Reserved = (1ULL << ReservedBP)
} Errors_E;

int main(void)
{
   Errors_E err, err2;

   err2 = (Errors_E)0x4321;
   err = (Errors_E)0x1234;
   if (err == 0x1234)
      err |= err2;
   return 0;
}
