/******************************************************************************/
/*                                                                            */
/*         Infentra Design Unit                                               */
/*                                                                            */
/******************************************************************************/
/*                                                                            */
/* All Rights Reserved Copyright (C) 2016-2017, Infentra solutions            */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or without         */
/* modification, are not permitted in any case                                */
/*                                                                            */
/* Infentra name may not be used to endorse or promote products derived from  */
/* this software without specific prior written permission.                   */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/* All Rights Reserved Copyright (C) 2016-2017, Infentra solutions  .         */
/*                                                                            */
/* \File Name   :    GPIO.h                                                   */
/* \Author      :    Vivek.K                                                  */
/* \Version     :    V7                                                       */
/* \Date        :    2/1/2017                                                 */
/*                                                                            */
/* Common Software Framework                                                  */
/******************************************************************************/

#ifndef PLATFORM_DRIVERS_GPIO_GPIO_H_
#define PLATFORM_DRIVERS_GPIO_GPIO_H_



//*****************************************************************************
//
// The following values define the bit field for the GPIO DIOs.
//
//*****************************************************************************
#define GPIO_DIO_0_MASK         0x00000001  // GPIO DIO 0 mask
#define GPIO_DIO_1_MASK         0x00000002  // GPIO DIO 1 mask
#define GPIO_DIO_2_MASK         0x00000004  // GPIO DIO 2 mask
#define GPIO_DIO_3_MASK         0x00000008  // GPIO DIO 3 mask
#define GPIO_DIO_4_MASK         0x00000010  // GPIO DIO 4 mask
#define GPIO_DIO_5_MASK         0x00000020  // GPIO DIO 5 mask
#define GPIO_DIO_6_MASK         0x00000040  // GPIO DIO 6 mask
#define GPIO_DIO_7_MASK         0x00000080  // GPIO DIO 7 mask
#define GPIO_DIO_8_MASK         0x00000100  // GPIO DIO 8 mask
#define GPIO_DIO_9_MASK         0x00000200  // GPIO DIO 9 mask
#define GPIO_DIO_10_MASK        0x00000400  // GPIO DIO 10 mask
#define GPIO_DIO_11_MASK        0x00000800  // GPIO DIO 11 mask
#define GPIO_DIO_12_MASK        0x00001000  // GPIO DIO 12 mask
#define GPIO_DIO_13_MASK        0x00002000  // GPIO DIO 13 mask
#define GPIO_DIO_14_MASK        0x00004000  // GPIO DIO 14 mask
#define GPIO_DIO_15_MASK        0x00008000  // GPIO DIO 15 mask
#define GPIO_DIO_16_MASK        0x00010000  // GPIO DIO 16 mask
#define GPIO_DIO_17_MASK        0x00020000  // GPIO DIO 17 mask
#define GPIO_DIO_18_MASK        0x00040000  // GPIO DIO 18 mask
#define GPIO_DIO_19_MASK        0x00080000  // GPIO DIO 19 mask
#define GPIO_DIO_20_MASK        0x00100000  // GPIO DIO 20 mask
#define GPIO_DIO_21_MASK        0x00200000  // GPIO DIO 21 mask
#define GPIO_DIO_22_MASK        0x00400000  // GPIO DIO 22 mask
#define GPIO_DIO_23_MASK        0x00800000  // GPIO DIO 23 mask
#define GPIO_DIO_24_MASK        0x01000000  // GPIO DIO 24 mask
#define GPIO_DIO_25_MASK        0x02000000  // GPIO DIO 25 mask
#define GPIO_DIO_26_MASK        0x04000000  // GPIO DIO 26 mask
#define GPIO_DIO_27_MASK        0x08000000  // GPIO DIO 27 mask
#define GPIO_DIO_28_MASK        0x10000000  // GPIO DIO 28 mask
#define GPIO_DIO_29_MASK        0x20000000  // GPIO DIO 29 mask
#define GPIO_DIO_30_MASK        0x40000000  // GPIO DIO 30 mask
#define GPIO_DIO_31_MASK        0x80000000  // GPIO DIO 31 mask
#define GPIO_DIO_ALL_MASK       0xFFFFFFFF  // GPIO all DIOs mask



typedef enum
{
    GPIO_SUCCESS = 0x00,
    GPIO_ERROR
}EN_GPIO_RESULT_t;


typedef enum
{
    DIO0 = 0x0,
    DIO1,
    DIO2,
    DIO3,
    DIO4,
    DIO5,
    DIO6,
    DIO7,
    DIO8,
    DIO9,
    DIO10,
    DIO11,
    DIO12,
    DIO13,
    DIO14,
    DIO15,
    DIO16,
    DIO17,
    DIO18,
    DIO19,
    DIO20,
    DIO21,
    DIO23,
    DIO24,
    DIO25,
    DIO26,
    DIO27,
    DIO28,
    DIO30,
    DIO31,
}EN_GPIO_PIN;


typedef enum
{
    GPIO_OUT = 0x0,
    GPIO_PUSH_PULL,
};

typedef struct
{
    EN_GPIO_PIN     en_gpio_pin;
}ST_GPIO_CONFIG;

extern EN_GPIO_RESULT_t GPIO_Init(ST_GPIO_CONFIG * fp_st_gpio_Config);

#endif /* PLATFORM_DRIVERS_GPIO_GPIO_H_ */
